set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9318922';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '0',
      '2',
      '0',
      '2',
      '4',
      '3',
      '4',
      '3',
      '3',
      '1',
      NULL,
      '0',
      '0',
      '4',
      NULL,
      '2',
      '2',
      '0',
      '1',
      '0',
      '3',
      '2',
      '',
      '1',
      NULL,
      '4',
      '0',
      '1',
      '0',
      '2',
      NULL,
      '',
      '1',
      '3',
      '2',
      '1',
      '3',
      '2',
      '0',
      '4',
      NULL,
      '4',
      '4',
      '002',
      '00334013',
      40,
      5,
      '1212243',
      NULL,
      1.672637,
      1,
      NULL,
      '202144',
      1.128907,
      ' 0-29-1974',
      NULL,
      28,
      NULL,
      11.048031,
      0.849831,
      9.684106,
      3.130619,
      30.566775,
      18.249688,
      27,
      16.576442,
      9.571120,
      NULL,
      NULL,
      19.750585,
      17.143664,
      8,
      21.995572,
      9.027986,
      54,
      NULL,
      47,
      2.826783,
      14,
      12.526242,
      0,
      110.785967,
      NULL,
      23.954431,
      169.757455,
      10.768701,
      210.010015,
      '11-26-2001',
      34.059378,
      12.425733,
      NULL,
      23.788106,
      NULL,
      134,
      ' 2- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      31.019138,
      1.160503,
      5.371366,
      2.353087,
      2,
      NULL,
      1.514489,
      1.085689,
      95,
      NULL,
      0,
      NULL,
      0.481007,
      0.388076,
      39,
      NULL,
      NULL,
      NULL,
      ' 1-29-1978',
      49.799015,
      60.032270,
      NULL,
      NULL,
      64.125190,
      NULL,
      78,
      68,
      NULL,
      75.906424,
      53.625848,
      28,
      ' 3- 9-1995',
      15.710214,
      4.933669,
      13,
      14.953107,
      15.862608,
      71,
      9.832992,
      ' 8- 2-1975',
      12.174633,
      NULL,
      '11-22-1978',
      6.597354,
      13,
      NULL,
      15,
      19.743853,
      10,
      0,
      NULL,
      1,
      54.738734,
      0.379487,
      1,
      0.336875,
      20.580908,
      NULL,
      0.842405,
      0.296511,
      NULL,
      ' 7-13-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      213,
      15,
      ' 2- 6-1978',
      NULL,
      NULL,
      NULL,
      22,
      ' 1- 2-1990',
      1.531685,
      ' 9-24-1994',
      12.993640,
      13.108011,
      NULL,
      46.905477,
      32,
      ' 1- 9-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      58,
      41,
      1.519641,
      ' 3- 2-1992',
      1,
      53.777878,
      ' 1-19-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


