set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1430',
      '23411143',
      '10103004',
      '03411210',
      NULL,
      '21044211',
      '10421322',
      '42333312',
      '40134314',
      '10233334',
      '43202413',
      NULL,
      NULL,
      NULL,
      '33414140',
      '03332121',
      '43242004',
      '40323132',
      '42300100',
      '14243101',
      '21041404',
      '00021233',
      '30031223',
      NULL,
      '32203114',
      '03011032',
      '21131142',
      NULL,
      NULL,
      NULL,
      '04130112',
      '04104442',
      NULL,
      '41142230',
      NULL,
      '04011201',
      '31242141',
      '32421423',
      '33010140',
      '40011204',
      '10031203',
      '22401101',
      '13204213',
      '02411233',
      '13111200',
      '244',
      '44',
      1.921491,
      13.189265,
      '4211422',
      1,
      0.380485,
      2,
      NULL,
      '020142',
      3,
      ' 4- 9-1989',
      NULL,
      NULL,
      36.951285,
      NULL,
      20,
      11,
      5,
      89,
      10,
      16,
      21,
      NULL,
      NULL,
      8.429125,
      22,
      2,
      NULL,
      20.797434,
      20.163033,
      5,
      NULL,
      20,
      5.870106,
      94,
      7,
      0,
      31,
      185.747251,
      49.650225,
      NULL,
      108,
      82.720662,
      '11-22-1989',
      NULL,
      7,
      7.234346,
      41.290986,
      245.791410,
      NULL,
      '11-16-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      17.918550,
      2,
      6,
      9.501992,
      3,
      ' 8-20-2001',
      NULL,
      1.345566,
      241.764797,
      1.181307,
      0,
      69,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 3-14-1983',
      14.647820,
      79.428282,
      88,
      94,
      NULL,
      59,
      52,
      103.859655,
      NULL,
      3,
      NULL,
      45.855401,
      '11- 5-2003',
      8,
      13,
      8.618846,
      11,
      63.784454,
      20.370359,
      7,
      ' 4-10-1994',
      NULL,
      0.331210,
      ' 8- 5-1989',
      NULL,
      5,
      NULL,
      24.786187,
      18,
      8,
      1,
      6.546339,
      0.605435,
      136,
      0,
      5.947628,
      24,
      11.744121,
      1,
      0.728084,
      0.225130,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      NULL,
      ' 1- 3-2003',
      NULL,
      NULL,
      NULL,
      46.548763,
      NULL,
      15.970163,
      ' 6- 1-1986',
      NULL,
      12,
      ' 1- 0-1985',
      95,
      7.344841,
      ' 6-23-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      19.031926,
      ' 8- 2-1983',
      7.221580,
      32.497873,
      NULL,
      '11-25-1979',
      NULL,
      95,
      ' 2-25-1992',
      9,
      15.345524,
      17,
      30,
      ' 2-14-1992',
      47.718062,
      0.237086,
      NULL,
      ' 4-20-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


