set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9624097';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4302',
      '00223423',
      NULL,
      NULL,
      '30133114',
      NULL,
      '43030323',
      '03444003',
      '23110322',
      '31223112',
      NULL,
      '41012031',
      NULL,
      '21430034',
      '44133313',
      '40144411',
      '21220414',
      NULL,
      '40010323',
      '22344121',
      '32423144',
      NULL,
      '43313114',
      '10121111',
      '11244340',
      '02403343',
      '41311240',
      NULL,
      '44124020',
      '24111123',
      '00133340',
      '14112101',
      '02444411',
      '10111322',
      '24010414',
      '44042420',
      '04431323',
      '32021412',
      '34344410',
      '03121322',
      '20314343',
      '04322130',
      NULL,
      '44330042',
      '10323104',
      NULL,
      '34',
      3.476948,
      NULL,
      '3142014',
      0.724692,
      23,
      3,
      NULL,
      NULL,
      2,
      ' 8-28-1989',
      ' 7-29-1999',
      30,
      142.393888,
      48.443828,
      24.420451,
      15,
      9,
      64,
      8.247221,
      18.301870,
      18.757835,
      26.989144,
      18,
      11,
      NULL,
      4.275924,
      0.050184,
      9,
      21,
      15.411236,
      6,
      14,
      NULL,
      NULL,
      31.051388,
      1,
      47.497665,
      NULL,
      60,
      24.844039,
      217,
      210,
      '10- 6-1974',
      NULL,
      76,
      NULL,
      NULL,
      7,
      NULL,
      ' 1- 4-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      11.561945,
      9.063287,
      1.613659,
      5.852000,
      6,
      ' 5- 8-2002',
      0.404498,
      3,
      63,
      1.219580,
      2.763458,
      174,
      1,
      NULL,
      103.250404,
      NULL,
      NULL,
      NULL,
      '10-26-2000',
      NULL,
      NULL,
      120,
      NULL,
      70,
      89,
      21.691004,
      89,
      NULL,
      NULL,
      NULL,
      110.653490,
      ' 4-18-1997',
      18,
      19,
      13,
      NULL,
      71,
      5,
      6,
      ' 4-18-2002',
      21.499254,
      NULL,
      ' 8-24-1984',
      21.969844,
      24.762908,
      8.701975,
      20.821172,
      NULL,
      7,
      NULL,
      24,
      1.270775,
      NULL,
      1.324197,
      0.599373,
      18,
      26.402180,
      0.807338,
      1,
      0,
      0,
      ' 5-19-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 7-13-1990',
      NULL,
      NULL,
      NULL,
      3.706338,
      ' 3-11-2001',
      19.591459,
      NULL,
      NULL,
      11,
      ' 3-21-1977',
      70.818301,
      85.669909,
      ' 5-22-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      15,
      '10- 9-1979',
      48,
      27.682929,
      49,
      ' 6-14-1993',
      0,
      63.011727,
      ' 6- 4-1992',
      1,
      2.390918,
      14,
      21,
      ' 0-26-2000',
      19.986509,
      0.688270,
      114.042187,
      ' 3-27-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


