set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9673213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1234',
      '22443333',
      NULL,
      '30401103',
      '13443441',
      '10134301',
      '32141213',
      '23214200',
      '14433321',
      NULL,
      '41433344',
      '33313121',
      '10041131',
      '11312011',
      '24034421',
      NULL,
      NULL,
      '40410422',
      '42143441',
      '40314142',
      '41143124',
      NULL,
      NULL,
      '31204042',
      NULL,
      '34321234',
      '40434143',
      '31040421',
      '11222210',
      '32444043',
      '21043100',
      '11132101',
      '31332013',
      '02003041',
      NULL,
      '20401030',
      '01223043',
      '23203001',
      '32334013',
      '42323204',
      '04102440',
      '12301141',
      '13434214',
      '33140040',
      NULL,
      '041',
      '12',
      2,
      18,
      NULL,
      3,
      1.991686,
      1,
      NULL,
      '030041',
      5,
      ' 9- 8-1984',
      '10-24-1984',
      135.263087,
      76,
      NULL,
      7,
      NULL,
      0.171900,
      23.152320,
      0.516515,
      10.618315,
      13.804089,
      NULL,
      1.930267,
      0,
      2.920574,
      11,
      0.410349,
      4.157760,
      9,
      0.170908,
      9,
      16.034906,
      5.635261,
      6.250611,
      3,
      1.344479,
      NULL,
      NULL,
      31.059083,
      77.519133,
      17.409078,
      103.052876,
      ' 6-17-1976',
      2,
      2,
      1.335116,
      8.429624,
      NULL,
      34,
      ' 1- 0-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.368694,
      25,
      12,
      18,
      5.328283,
      NULL,
      2.596566,
      1,
      18.446156,
      NULL,
      NULL,
      43,
      6,
      2,
      35.048449,
      NULL,
      NULL,
      NULL,
      ' 2- 3-1978',
      5.702519,
      19.895038,
      34,
      63,
      18.769117,
      39,
      44.384593,
      53.252356,
      NULL,
      NULL,
      60,
      11.798247,
      NULL,
      3.578930,
      5,
      3.690340,
      7.256015,
      1.974576,
      NULL,
      NULL,
      ' 0- 7-1993',
      15,
      12,
      ' 9- 6-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      ' 7-23-1984',
      9.687750,
      7.340377,
      ' 6-22-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.133938,
      ' 1-16-1981',
      NULL,
      4.397682,
      14,
      ' 7- 1-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.284776,
      NULL,
      215.016783,
      ' 7- 6-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


