set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9673213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '3',
      '1',
      '4',
      NULL,
      NULL,
      '3',
      NULL,
      '0',
      NULL,
      '2',
      '2',
      '1',
      '0',
      '1',
      '3',
      '2',
      '0',
      '1',
      '4',
      '0',
      '',
      '1',
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      '',
      '0',
      '1',
      '2',
      '2',
      '0',
      '1',
      '0',
      '2',
      '3',
      '0',
      '1',
      '222',
      '20111124',
      10,
      46,
      NULL,
      0.143968,
      1,
      NULL,
      NULL,
      '331433',
      2,
      ' 1- 3-1995',
      NULL,
      63,
      166.987132,
      4.259570,
      3.494398,
      11,
      9,
      0,
      2,
      5,
      5,
      9.039624,
      6.438583,
      NULL,
      5.345514,
      0,
      3.152615,
      NULL,
      0.711358,
      5,
      2.468609,
      NULL,
      3.354708,
      19,
      3,
      0,
      22.125496,
      111.106935,
      5.907407,
      119,
      NULL,
      23,
      ' 6- 7-1997',
      NULL,
      NULL,
      16,
      10.150883,
      11,
      NULL,
      ' 6-28-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84.781818,
      20.273720,
      NULL,
      2,
      NULL,
      2.126481,
      ' 1-22-1980',
      0.983561,
      0.629798,
      80,
      1.925716,
      NULL,
      48.990311,
      1.699068,
      7.706477,
      17,
      NULL,
      NULL,
      NULL,
      ' 4-21-1999',
      5.659304,
      7,
      9,
      14.030526,
      32,
      7.180739,
      NULL,
      20.979390,
      22.967495,
      27,
      38.143936,
      NULL,
      ' 6-10-1995',
      3.512870,
      NULL,
      1,
      0.054963,
      18,
      0,
      1.682298,
      ' 8-24-1977',
      4.772586,
      1.375821,
      ' 4-19-1977',
      1.833667,
      7.122330,
      1,
      3,
      11.451197,
      3,
      1,
      NULL,
      1.206526,
      13.164004,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      0,
      NULL,
      ' 6-24-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.268109,
      ' 2-22-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      ' 9-23-1987',
      55.756041,
      0,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.319505,
      189.251071,
      ' 4- 7-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


