set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9778338';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '1',
      '0',
      '1',
      '3',
      '2',
      NULL,
      '4',
      '3',
      '0',
      '0',
      NULL,
      NULL,
      '2',
      '1',
      '4',
      '4',
      '2',
      '3',
      '4',
      '3',
      '3',
      NULL,
      '',
      '1',
      '',
      '1',
      '1',
      '0',
      '2',
      '1',
      NULL,
      '',
      '2',
      '0',
      '4',
      NULL,
      '1',
      '1',
      '0',
      '3',
      '4',
      '3',
      '4',
      '142',
      '22131100',
      NULL,
      18,
      '0311440',
      NULL,
      1.215856,
      0,
      NULL,
      '311010',
      4.902838,
      ' 1-21-1980',
      ' 0-27-1998',
      53,
      234.970290,
      31,
      21,
      17,
      NULL,
      NULL,
      14.477623,
      9,
      NULL,
      21.567514,
      3,
      8.744360,
      16,
      NULL,
      13,
      15,
      6.659535,
      55.811797,
      1,
      NULL,
      10.292496,
      120.750713,
      NULL,
      1.866021,
      NULL,
      108.820016,
      NULL,
      97,
      46.049072,
      54.405221,
      NULL,
      18.060098,
      48,
      1,
      8.232294,
      202,
      23.622581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.337432,
      2.426376,
      5.235215,
      7.386826,
      NULL,
      ' 0-25-1987',
      0.795418,
      2.544641,
      NULL,
      0,
      0.429802,
      31,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 9-2002',
      79,
      88.968725,
      80,
      101,
      NULL,
      69,
      79,
      26.847311,
      89,
      24.509878,
      15,
      NULL,
      ' 8-23-1999',
      NULL,
      12.799119,
      16.829183,
      28,
      44,
      6,
      3,
      ' 3-26-1984',
      13.154359,
      11,
      ' 6-18-1983',
      NULL,
      NULL,
      13,
      2.201874,
      3,
      3,
      1,
      14.542236,
      0,
      79,
      1.134675,
      1,
      6.743989,
      12.159083,
      1,
      0,
      0,
      0.303411,
      ' 0-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.325924,
      '11- 9-1996',
      NULL,
      NULL,
      NULL,
      31.825002,
      ' 0-13-2003',
      2.396221,
      ' 3- 4-1985',
      9.985408,
      5.161818,
      NULL,
      48.222442,
      NULL,
      ' 2-25-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '11- 9-1976',
      20.550014,
      12,
      24.856574,
      ' 8- 8-1998',
      0,
      37,
      ' 9-24-1986',
      4,
      2.201831,
      3,
      38,
      NULL,
      10,
      1.502499,
      96.775514,
      ' 1- 9-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


