set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9622970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4302',
      '03034424',
      '43424202',
      '23004024',
      '00412000',
      NULL,
      '30033342',
      '30231213',
      '10124113',
      NULL,
      '22103301',
      '22134302',
      '01211241',
      '41300300',
      '32130302',
      '13143323',
      '01123000',
      '24010411',
      NULL,
      '10113122',
      '13100144',
      '41040342',
      '00000433',
      '11043423',
      NULL,
      '24024443',
      NULL,
      '44042002',
      '21100301',
      '32141203',
      NULL,
      '30304330',
      '40321124',
      '02432204',
      '23100020',
      '43111233',
      '13322211',
      '30432423',
      '24324402',
      '44431401',
      '32211332',
      '20334030',
      '42424011',
      '11001043',
      '42441143',
      '340',
      '23',
      31,
      12,
      '3141231',
      NULL,
      1,
      3,
      NULL,
      '101112',
      1,
      ' 2- 1-1976',
      '11-22-1996',
      93,
      78.429202,
      3,
      8.473455,
      18.863124,
      13.513796,
      68,
      1.317165,
      15.285294,
      8.231773,
      23,
      4.588231,
      1,
      NULL,
      11,
      0.131821,
      15,
      2.575128,
      39.700780,
      NULL,
      38,
      3.914850,
      13,
      17.140113,
      0,
      99.678959,
      144,
      46.035011,
      NULL,
      174.364805,
      24,
      ' 1-28-1987',
      NULL,
      NULL,
      6,
      7,
      NULL,
      179.660469,
      ' 5-15-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.823668,
      2.617121,
      5.155715,
      17,
      11,
      9,
      ' 7-24-1991',
      1,
      0.587618,
      NULL,
      0.000108,
      0,
      0.109145,
      0,
      3,
      30,
      NULL,
      NULL,
      NULL,
      ' 2-15-1992',
      73.867822,
      31,
      17,
      89.392553,
      49.330557,
      71,
      NULL,
      84,
      38.073220,
      NULL,
      NULL,
      43,
      NULL,
      12,
      3.864422,
      3.166689,
      28,
      NULL,
      31.071382,
      7.095183,
      NULL,
      13,
      3.033869,
      ' 7- 3-1989',
      1.386918,
      NULL,
      NULL,
      NULL,
      15,
      3.202980,
      0,
      5.333462,
      1,
      20.743106,
      0.326798,
      NULL,
      19,
      25.288353,
      1.851614,
      1.138382,
      1,
      0.035825,
      ' 7-28-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      ' 8- 3-1981',
      35,
      ' 0- 8-1986',
      NULL,
      13.954022,
      NULL,
      NULL,
      74.510468,
      ' 1-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      10.884612,
      ' 2-14-1981',
      38,
      31.407918,
      NULL,
      '10- 0-1974',
      0.624519,
      83,
      ' 0- 7-1974',
      6,
      31,
      14,
      24,
      '11-18-1979',
      8.518737,
      1.487387,
      NULL,
      ' 5-14-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


