set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7833744';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2204',
      '22331000',
      '42430320',
      '23324324',
      NULL,
      '34033334',
      '34101441',
      NULL,
      NULL,
      '13104040',
      '22044002',
      '01032442',
      '00311204',
      '41204230',
      NULL,
      '30340304',
      '22420103',
      '40302434',
      '33134034',
      '03341432',
      '44202003',
      '31413343',
      '21214411',
      NULL,
      '44014332',
      '12001142',
      NULL,
      '31301312',
      '02240142',
      '41424233',
      NULL,
      '03333110',
      '44302111',
      '22203121',
      '43411124',
      '42442323',
      '24041112',
      '44034342',
      '30001034',
      '21000213',
      '02232323',
      NULL,
      '13344233',
      '31100431',
      NULL,
      '231',
      '23',
      1.008231,
      6.733952,
      '0122220',
      2.329831,
      1,
      2,
      NULL,
      NULL,
      1.900071,
      ' 8-21-1981',
      ' 9-26-1974',
      NULL,
      73,
      31,
      17.888612,
      NULL,
      NULL,
      63.858395,
      0.104124,
      8,
      7.578229,
      2.434198,
      0.430579,
      34,
      7.253230,
      8,
      3.878943,
      0.577361,
      5.049531,
      17,
      NULL,
      5.332755,
      5,
      18,
      11.085385,
      0.795175,
      65.606345,
      22.240215,
      NULL,
      NULL,
      18,
      144.939868,
      NULL,
      11,
      NULL,
      4.798894,
      7,
      45.971418,
      42.907009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      2,
      12.662940,
      44.266793,
      16,
      NULL,
      ' 3-13-2003',
      NULL,
      NULL,
      148.712997,
      0.423815,
      5,
      30.295679,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 0-1999',
      49.373475,
      18,
      23,
      4.665798,
      4,
      20.614288,
      40.378411,
      30,
      22.542834,
      NULL,
      23.264051,
      6.320523,
      ' 7-29-1992',
      6,
      7.426581,
      1.105726,
      NULL,
      14,
      62,
      2.519498,
      ' 5- 6-1998',
      17.896987,
      4,
      ' 1-15-1980',
      11,
      NULL,
      NULL,
      6.788839,
      NULL,
      5.101832,
      0.798501,
      15.385373,
      0.887345,
      35,
      NULL,
      NULL,
      0.065604,
      9.706458,
      6.096113,
      NULL,
      1.619389,
      NULL,
      ' 4-16-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      ' 0-15-1988',
      37.901131,
      '10-14-1983',
      9,
      0,
      ' 7-24-1980',
      NULL,
      12.167962,
      ' 7- 7-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      9,
      ' 2-12-1975',
      8.258489,
      NULL,
      NULL,
      ' 1-20-1977',
      3.179725,
      104.038667,
      ' 3- 1-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      108.485284,
      '11- 7-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


