set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203364';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      '2',
      '4',
      '4',
      '2',
      '0',
      '2',
      '2',
      '1',
      '4',
      '1',
      '0',
      '4',
      '4',
      '4',
      '3',
      '3',
      '2',
      '3',
      '0',
      '3',
      '0',
      '',
      '3',
      '',
      '0',
      NULL,
      '4',
      '3',
      '0',
      '',
      '',
      '3',
      '0',
      NULL,
      '4',
      '0',
      '1',
      '3',
      '0',
      '1',
      '1',
      NULL,
      NULL,
      '02432102',
      11.990176,
      21.722221,
      NULL,
      2,
      1,
      3,
      NULL,
      '102144',
      0,
      NULL,
      ' 3-18-1990',
      55,
      NULL,
      21.540678,
      1.652208,
      12.434859,
      1.491231,
      NULL,
      2.115559,
      NULL,
      10.427932,
      20,
      NULL,
      NULL,
      2.001032,
      16,
      9.323185,
      0.524474,
      4.887327,
      29,
      8.969556,
      11,
      15,
      NULL,
      5.950628,
      NULL,
      96.058095,
      107.834509,
      33,
      56.722341,
      55.941017,
      136.789387,
      ' 1-23-1998',
      38.345039,
      13,
      0.897654,
      34,
      44.281369,
      219.222567,
      ' 8-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.383073,
      16.078569,
      31.723264,
      7.187354,
      24.064781,
      4,
      ' 9-27-1976',
      1,
      0,
      101.227446,
      1.660155,
      1.053950,
      48,
      1.500688,
      0.135640,
      55.972130,
      NULL,
      NULL,
      NULL,
      ' 9-27-1978',
      69,
      58,
      39.430953,
      NULL,
      31,
      76.018613,
      53,
      58,
      8,
      5.915231,
      78.231621,
      72.910407,
      ' 8-17-1975',
      17.354877,
      10,
      23,
      29.727993,
      19,
      46,
      6.685111,
      ' 2- 0-2003',
      NULL,
      2.072878,
      '10- 2-1985',
      14.180706,
      7.009934,
      NULL,
      NULL,
      26,
      NULL,
      1,
      16,
      0.297134,
      11,
      1.731329,
      NULL,
      21,
      13.985418,
      0.868239,
      NULL,
      0.789909,
      0.882868,
      ' 3- 7-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      213,
      5,
      ' 0- 2-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      ' 3- 0-1999',
      21.998768,
      5,
      ' 0-17-1984',
      129.949134,
      15,
      '11-11-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      ' 8-17-1994',
      NULL,
      8,
      8,
      ' 3-20-1999',
      1,
      3.357692,
      ' 4-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


