set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4034',
      '34342112',
      '13423003',
      '22214443',
      '44023334',
      '02020000',
      '12102212',
      '20333301',
      NULL,
      NULL,
      '41144112',
      '33342433',
      '00211134',
      '14140431',
      NULL,
      NULL,
      '03102411',
      '13311413',
      '24223442',
      '34004202',
      '32110241',
      NULL,
      '20121034',
      '10400401',
      '31420320',
      '41431341',
      '31033342',
      '04230304',
      '22113134',
      '21323124',
      '40111330',
      '04431143',
      '23323034',
      '02114314',
      '32031414',
      '34141334',
      NULL,
      NULL,
      '30230111',
      '03141103',
      NULL,
      '20144444',
      '13032442',
      '42033202',
      '24333320',
      '324',
      '32',
      NULL,
      NULL,
      '4301303',
      4.392484,
      1,
      0,
      NULL,
      '243412',
      0,
      ' 1-20-2001',
      ' 0- 0-2001',
      16.146636,
      NULL,
      23,
      24.312111,
      6,
      2.107494,
      26.085708,
      10.197318,
      3,
      13,
      19,
      NULL,
      28,
      7.648042,
      27.872330,
      3,
      2.210317,
      15.100069,
      32.531181,
      4,
      59,
      15.123059,
      4,
      1,
      1,
      NULL,
      79.190265,
      40,
      NULL,
      116,
      124,
      ' 4-16-1993',
      3,
      10,
      13.509769,
      13,
      NULL,
      93.749003,
      NULL,
      0.774340,
      NULL,
      0,
      3,
      1.550625,
      4,
      NULL,
      NULL,
      1,
      1,
      1.591340,
      1,
      0,
      3.269721,
      1,
      0.808220,
      9.288663,
      0.040528,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.012301,
      3.085857,
      20.019701,
      10.284788,
      3,
      NULL,
      ' 8-23-1987',
      0.300278,
      1.798929,
      40,
      0,
      3,
      45.498255,
      9.055466,
      1.436550,
      56.725858,
      NULL,
      NULL,
      NULL,
      ' 5- 9-2001',
      43,
      11,
      NULL,
      30.695384,
      33,
      0,
      57,
      NULL,
      NULL,
      8.774744,
      45,
      21.696103,
      ' 1- 2-1982',
      8,
      11.096384,
      7.889682,
      47,
      0,
      NULL,
      2.362241,
      NULL,
      NULL,
      NULL,
      ' 5- 1-1981',
      7.549581,
      NULL,
      9,
      16.315279,
      14.832051,
      11,
      0.180142,
      6,
      1,
      NULL,
      1,
      3.344064,
      2,
      9.523552,
      0,
      1,
      NULL,
      1,
      '11-21-1988',
      1.618714,
      2.541564,
      NULL,
      '10-14-2002',
      6,
      1.422235,
      NULL,
      NULL,
      NULL,
      NULL,
      52.597857,
      ' 0- 3-2003',
      15,
      ' 0-16-1975',
      2.573853,
      7.108295,
      ' 4-12-1994',
      98,
      5.699481,
      ' 5-19-1987',
      NULL,
      NULL,
      ' 5- 3-1981',
      0.350634,
      15,
      ' 8-18-1983',
      0,
      NULL,
      4.033421,
      '10-23-1986',
      NULL,
      13.785938,
      3.821669,
      ' 7-17-1986',
      1,
      173.613787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6);
commit;
end;
/


