set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2032',
      '31202342',
      '23130000',
      '11134223',
      '42330120',
      NULL,
      '23142014',
      NULL,
      '32334314',
      '23003234',
      '31310223',
      '32212240',
      NULL,
      '12312401',
      '12044134',
      '43443221',
      '24212113',
      '11014311',
      '42414403',
      '11232003',
      NULL,
      '43001314',
      '34002203',
      '31433334',
      '20342222',
      '31411301',
      '12100411',
      '20314424',
      '02241330',
      NULL,
      '12423400',
      '42141002',
      NULL,
      '32230231',
      NULL,
      '14404144',
      '22321332',
      '21021112',
      '01444042',
      '30040012',
      NULL,
      '23441413',
      NULL,
      '31404022',
      NULL,
      '043',
      '42',
      25.815812,
      10.367708,
      '3111141',
      7,
      0,
      2,
      NULL,
      '402010',
      NULL,
      ' 5-21-1995',
      '10-11-1980',
      NULL,
      NULL,
      1,
      20,
      5.164722,
      12,
      59,
      11,
      8.285969,
      19,
      NULL,
      0,
      22,
      20,
      13.622586,
      NULL,
      19,
      10,
      26,
      5,
      NULL,
      NULL,
      NULL,
      0.393988,
      0,
      78.098769,
      NULL,
      73,
      86,
      108.019147,
      35.936587,
      ' 0-21-1988',
      39.098533,
      8.836322,
      28,
      7,
      137.601035,
      116.373944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.855747,
      34.350649,
      14.625557,
      NULL,
      NULL,
      4.952834,
      ' 3-23-1985',
      5,
      NULL,
      25.186623,
      0,
      0,
      133,
      1,
      NULL,
      51.506760,
      NULL,
      NULL,
      NULL,
      ' 8- 5-1998',
      29.299047,
      34,
      21.520479,
      22,
      19.881622,
      21,
      NULL,
      11.934651,
      24,
      NULL,
      NULL,
      5,
      ' 1-28-2000',
      7.082227,
      6.245702,
      6,
      55,
      NULL,
      59.500942,
      NULL,
      ' 9-10-2003',
      21.062928,
      NULL,
      ' 6-13-1995',
      6.990194,
      1.857459,
      12.813304,
      3.398987,
      NULL,
      7.877118,
      2,
      13.755691,
      1.061273,
      44,
      1,
      10.494301,
      1,
      22,
      1,
      9.070907,
      5.861544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.237637,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      10.321506,
      ' 4-26-2002',
      3.533948,
      ' 9-11-1981',
      NULL,
      2,
      ' 3-14-1984',
      1,
      66.513405,
      ' 4-17-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      10.276934,
      ' 1-25-1978',
      71.605781,
      0.753874,
      7,
      ' 6-13-1998',
      1.375485,
      NULL,
      ' 4-17-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.825929,
      1,
      78,
      ' 5- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


