set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9966597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '0',
      '2',
      '4',
      '3',
      '1',
      '0',
      '3',
      '1',
      '2',
      NULL,
      '2',
      '4',
      '4',
      '1',
      '0',
      '4',
      '3',
      '1',
      '1',
      '2',
      NULL,
      '4',
      '',
      '1',
      NULL,
      NULL,
      '1',
      '1',
      '4',
      '3',
      '',
      '',
      NULL,
      '3',
      '3',
      '3',
      NULL,
      NULL,
      '0',
      '1',
      '0',
      '1',
      '2',
      NULL,
      '44243323',
      46,
      37.132801,
      '2123400',
      NULL,
      0,
      0,
      0,
      '011004',
      1.165116,
      ' 1- 1-1989',
      ' 8- 2-1992',
      46.566610,
      102.422474,
      11,
      0.134314,
      NULL,
      NULL,
      13,
      NULL,
      33.445361,
      8.702224,
      2,
      2.056822,
      18.375037,
      8,
      23,
      NULL,
      NULL,
      13,
      47.672661,
      28,
      NULL,
      9.761585,
      57,
      12,
      0,
      6,
      55,
      105.034019,
      109.002145,
      139.836269,
      33.807547,
      NULL,
      16,
      4.143697,
      33.191832,
      16,
      40,
      143.587020,
      ' 6-29-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      6,
      2.571592,
      12.374300,
      3,
      NULL,
      0.706402,
      1,
      175.992767,
      1.179668,
      NULL,
      108.386140,
      NULL,
      1.871211,
      46.280283,
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      20,
      4,
      NULL,
      6,
      37,
      27,
      17,
      80.727868,
      69,
      NULL,
      29,
      ' 0- 8-1974',
      38.206445,
      8.520903,
      2,
      NULL,
      27.483997,
      1,
      10.988713,
      '11- 9-1978',
      NULL,
      NULL,
      ' 0- 9-1979',
      5.470327,
      7,
      1,
      12,
      8.253739,
      3,
      0.364657,
      12,
      0,
      NULL,
      1.046367,
      NULL,
      13.239811,
      20,
      3.823040,
      1.579802,
      0,
      2.312576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.592613,
      ' 9- 3-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-24-1988',
      2.179438,
      NULL,
      0,
      15,
      ' 8-27-1989',
      47,
      NULL,
      ' 8- 5-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      16,
      ' 6-19-1980',
      48,
      3.851103,
      NULL,
      ' 5-16-2001',
      0,
      97,
      ' 0- 9-1993',
      NULL,
      18,
      5,
      24.330331,
      ' 4- 3-1987',
      NULL,
      0,
      92,
      ' 9-21-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


