set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3124',
      '22002140',
      '40303101',
      '34312220',
      '04221212',
      NULL,
      '22202411',
      '02042440',
      '11133044',
      '43333443',
      '10101420',
      '31213024',
      '40443342',
      NULL,
      '20422334',
      '22343214',
      '13321411',
      '01414421',
      '10224111',
      '21142044',
      '04242311',
      '03013221',
      '41323423',
      '32340423',
      '42413211',
      NULL,
      '41012223',
      '14210332',
      '31040313',
      NULL,
      '44030113',
      '44402112',
      '10002401',
      '13443011',
      '32113410',
      '33100312',
      '24121141',
      '22322324',
      NULL,
      '21322032',
      '41014102',
      '32300313',
      '12010121',
      '30332234',
      '41100243',
      '102',
      '30',
      NULL,
      NULL,
      NULL,
      2.983520,
      1,
      3,
      NULL,
      '133212',
      NULL,
      NULL,
      NULL,
      16.833466,
      NULL,
      32.093530,
      4,
      NULL,
      9,
      103,
      12,
      6.733941,
      3,
      23.243287,
      NULL,
      31.738788,
      2.602475,
      21,
      7.655385,
      20,
      NULL,
      20,
      11.721772,
      67.606470,
      6,
      NULL,
      16,
      0.967461,
      29.970783,
      95,
      NULL,
      37,
      13.362798,
      144.607796,
      '10-28-1997',
      28,
      12,
      35.149610,
      4.942901,
      36.961671,
      178.043404,
      NULL,
      0,
      NULL,
      8,
      1.706686,
      5.225251,
      3.101692,
      2,
      1,
      1,
      0.981836,
      0.924028,
      0,
      0.237153,
      1.629184,
      NULL,
      1.770010,
      2.748248,
      NULL,
      0,
      1.708141,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-26-1986',
      54,
      13.005060,
      15.253458,
      7.580274,
      15.060479,
      0.370470,
      ' 0-14-2001',
      1.047226,
      0.490917,
      119.221502,
      1.174116,
      1.698053,
      85.405334,
      5,
      3,
      31.280377,
      NULL,
      NULL,
      NULL,
      ' 6-14-1984',
      68.446053,
      9,
      27.879023,
      83.389178,
      NULL,
      54.568689,
      81.350550,
      6.786444,
      35.310521,
      81,
      4,
      9,
      NULL,
      23,
      NULL,
      NULL,
      22,
      50.879375,
      30,
      5,
      ' 5- 3-1985',
      21,
      11.429758,
      ' 2- 6-1979',
      1,
      15.538594,
      NULL,
      17.269838,
      3,
      11.100143,
      1.203337,
      9,
      NULL,
      0,
      0,
      NULL,
      14,
      6.727139,
      0,
      NULL,
      1.283988,
      1,
      ' 1- 1-1993',
      3,
      NULL,
      3.571417,
      ' 2- 7-1993',
      70,
      NULL,
      ' 9-20-2003',
      NULL,
      NULL,
      NULL,
      16.453202,
      ' 9-27-1994',
      15.337269,
      ' 1- 0-2003',
      15.278865,
      NULL,
      ' 6-20-1991',
      NULL,
      NULL,
      ' 1-22-1998',
      0.997260,
      5.688820,
      ' 6-23-1976',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.668358,
      '11-19-1977',
      53,
      NULL,
      1.692023,
      NULL,
      2,
      118.000834,
      NULL,
      6.582596,
      71,
      6,
      66.644187,
      ' 2-11-1976',
      13,
      7,
      24.865286,
      ' 0-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9);
commit;
end;
/


