set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9413730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2241',
      '12314140',
      '44343140',
      NULL,
      NULL,
      '31140021',
      '23111210',
      '42331341',
      '30103034',
      '41233221',
      NULL,
      '33122134',
      '00343240',
      '02312400',
      '42422311',
      '14434330',
      '03220204',
      NULL,
      '24104244',
      NULL,
      '24111014',
      '14140214',
      NULL,
      NULL,
      NULL,
      '33413022',
      NULL,
      NULL,
      '32310203',
      '43231244',
      '04111110',
      NULL,
      '44221341',
      '40414111',
      NULL,
      '11204034',
      NULL,
      '04324033',
      '30140204',
      '31404112',
      NULL,
      NULL,
      '13304333',
      '03124344',
      '34123443',
      '011',
      '44',
      NULL,
      NULL,
      '1430101',
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-1999',
      ' 3-27-2000',
      NULL,
      87,
      NULL,
      13,
      NULL,
      12.633119,
      43,
      22.669839,
      20.943986,
      5,
      41.675166,
      NULL,
      NULL,
      23.811146,
      10.584358,
      11,
      NULL,
      16,
      28,
      16,
      11,
      7,
      NULL,
      9,
      1.436798,
      16.137263,
      196,
      NULL,
      3.184294,
      171,
      209.256442,
      NULL,
      NULL,
      32,
      8.993885,
      7,
      165,
      152.553198,
      ' 6- 6-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.991492,
      22.260180,
      7,
      11.129249,
      3,
      NULL,
      ' 6-14-1996',
      1,
      1.112663,
      79.618690,
      1,
      0,
      171.290707,
      1.098843,
      1.234955,
      44,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      75,
      97,
      60,
      61,
      8,
      58.865706,
      99,
      NULL,
      2,
      39,
      3,
      '11- 1-1979',
      5.479411,
      12.530356,
      0.699636,
      10,
      11,
      17,
      NULL,
      ' 4-22-1978',
      0.126919,
      NULL,
      NULL,
      6.152283,
      NULL,
      11.259761,
      10,
      4,
      3.134476,
      NULL,
      1.667327,
      NULL,
      NULL,
      0.068528,
      6,
      0.521638,
      29,
      1.258396,
      1.914194,
      2,
      0.924207,
      ' 7-13-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      0.960429,
      ' 2- 0-1985',
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      ' 1- 8-1992',
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      ' 3-28-1979',
      9.853990,
      11.291480,
      28.023937,
      ' 1- 1-1994',
      NULL,
      NULL,
      ' 7-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


