set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2330',
      '00142110',
      '04331044',
      '00001300',
      NULL,
      '34010120',
      '31231210',
      '03410201',
      '23341412',
      '23403202',
      '13102020',
      '30214344',
      '43202012',
      '22423404',
      '20240023',
      '03320201',
      '31020233',
      '20100014',
      NULL,
      '13024431',
      '14043333',
      '00111041',
      '43024000',
      '30441433',
      '31214234',
      NULL,
      '23014341',
      '20240401',
      '42101243',
      '41324201',
      '20012300',
      '41332313',
      '02133142',
      '31411431',
      '10230321',
      NULL,
      '11412312',
      NULL,
      '44134333',
      '04104140',
      '03020323',
      '20412040',
      '31403433',
      '20231410',
      '40321010',
      NULL,
      '24',
      35.180778,
      4.911848,
      NULL,
      0.744568,
      1.147591,
      2,
      NULL,
      NULL,
      NULL,
      ' 2-12-1982',
      ' 2- 5-1993',
      24.399446,
      NULL,
      NULL,
      18,
      25,
      23,
      38.190401,
      0.678889,
      NULL,
      NULL,
      25.650575,
      6,
      7.657260,
      7.643391,
      17.286345,
      19.318399,
      11.572772,
      13.090854,
      NULL,
      NULL,
      30.382594,
      18.255139,
      98.264321,
      8.964398,
      0.082257,
      59,
      14.831586,
      27.736209,
      2.572342,
      160.388829,
      25,
      ' 1-19-1987',
      15,
      53,
      1.558083,
      22.456388,
      74.401843,
      188,
      ' 9-15-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.861388,
      27,
      12,
      10,
      0,
      5.336218,
      ' 6- 6-1999',
      1.227473,
      2.475169,
      183.686145,
      0,
      NULL,
      158,
      1,
      2,
      24,
      NULL,
      NULL,
      NULL,
      ' 5- 9-1995',
      20,
      NULL,
      56,
      85.375565,
      104.156193,
      47.501520,
      39.759903,
      14,
      15.518038,
      70,
      94.031268,
      52.061807,
      ' 7-25-1982',
      NULL,
      22.301827,
      1.981647,
      39,
      14,
      54,
      5.404993,
      ' 9-27-1977',
      0,
      0.684894,
      NULL,
      3,
      11.785294,
      6.548139,
      3.278439,
      22.400645,
      13.789352,
      0,
      11.847516,
      1,
      107,
      0.099814,
      3.247090,
      4.807302,
      NULL,
      NULL,
      1,
      1,
      0,
      '11-10-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      240,
      1,
      '10-15-1975',
      NULL,
      NULL,
      NULL,
      26.637590,
      '11-25-2003',
      33,
      NULL,
      14.437838,
      NULL,
      ' 0-27-1981',
      24,
      62.234118,
      ' 0- 2-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      25.154927,
      NULL,
      28,
      46,
      37.495870,
      ' 4-14-1975',
      0.350001,
      NULL,
      ' 0-20-2001',
      7.100745,
      30,
      3.283882,
      4,
      ' 0-10-1977',
      39,
      1,
      92.027551,
      '10- 9-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


