set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4440',
      '04044443',
      '24021002',
      '31212323',
      '40303122',
      '31042120',
      '01332421',
      '21110244',
      '30420344',
      '20104240',
      '10121301',
      '01034321',
      '03421232',
      '01221230',
      NULL,
      '11221311',
      '20200201',
      '24302003',
      '22431310',
      '32222140',
      '41031144',
      '03334304',
      '03004443',
      '13031342',
      '02133404',
      '43430342',
      NULL,
      '32014243',
      '14030302',
      '11423234',
      NULL,
      '13401220',
      '44143040',
      '44440344',
      '30034403',
      NULL,
      '14224024',
      '31034001',
      '00242142',
      '42231230',
      '22344242',
      '43134441',
      '00244240',
      '11442143',
      '22233342',
      '432',
      '12',
      5.648155,
      14.853645,
      NULL,
      3,
      33.606536,
      1,
      NULL,
      '224242',
      4.696353,
      NULL,
      ' 2- 9-1985',
      103.332610,
      17.495990,
      32,
      19,
      22,
      NULL,
      31.063567,
      NULL,
      14.711879,
      NULL,
      2.830104,
      3,
      1,
      16,
      9,
      15,
      7.445407,
      15,
      3.474674,
      9.601156,
      9.659047,
      13,
      127.833394,
      NULL,
      1.917658,
      NULL,
      NULL,
      62,
      4,
      21,
      106,
      ' 7-10-2001',
      28.322364,
      44,
      19.988200,
      36,
      16.353770,
      NULL,
      ' 6-23-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.164083,
      NULL,
      NULL,
      NULL,
      5,
      '10-13-2000',
      1,
      1.171466,
      84.026657,
      0,
      NULL,
      77.214280,
      1,
      1,
      5.695489,
      NULL,
      NULL,
      NULL,
      ' 2-28-1985',
      NULL,
      5,
      NULL,
      54,
      44,
      52.875399,
      56,
      76,
      77.090979,
      NULL,
      17,
      NULL,
      NULL,
      7,
      4.905962,
      1,
      26,
      54,
      73,
      NULL,
      NULL,
      4,
      3,
      '11-14-1991',
      0.804660,
      17,
      12.539751,
      3.904612,
      3.513987,
      10.120469,
      0,
      10,
      0.365984,
      45,
      0.358944,
      1,
      13.202589,
      21.016255,
      1.487781,
      NULL,
      1,
      0.031065,
      ' 5- 5-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      299,
      NULL,
      ' 8-12-2002',
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      41,
      ' 8-19-1988',
      NULL,
      21.544572,
      NULL,
      24,
      26.234875,
      '10- 1-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      ' 0- 2-1980',
      32,
      NULL,
      25.424794,
      ' 7-22-1981',
      1,
      63.057232,
      ' 6-17-1991',
      15,
      0,
      15,
      NULL,
      ' 6-12-1977',
      70.388578,
      1,
      6.243395,
      ' 6-17-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


