set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '2',
      '4',
      NULL,
      '0',
      NULL,
      '4',
      '1',
      '1',
      NULL,
      '0',
      '4',
      '3',
      '0',
      '1',
      '2',
      '3',
      '1',
      '0',
      '4',
      '0',
      '1',
      '4',
      '',
      '0',
      '',
      '3',
      NULL,
      '4',
      '3',
      '0',
      '',
      NULL,
      NULL,
      '1',
      '2',
      '1',
      '0',
      '0',
      NULL,
      '0',
      '3',
      '4',
      NULL,
      '420',
      '32012134',
      37,
      52,
      '1140313',
      1.005078,
      NULL,
      2,
      NULL,
      '121103',
      2.068742,
      ' 5-20-1981',
      ' 7- 6-1983',
      35,
      71.717134,
      38.014483,
      18,
      3.155950,
      0,
      NULL,
      8.016398,
      1.191217,
      14,
      10,
      7,
      19,
      22,
      8,
      9,
      15,
      NULL,
      43.075781,
      9,
      64.032317,
      9.458130,
      74.661926,
      7,
      2.046138,
      28.285124,
      NULL,
      28,
      97.765362,
      70.686477,
      55.734247,
      ' 4-11-1974',
      23.840928,
      48.412459,
      NULL,
      25,
      63.696002,
      137,
      ' 4-21-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.725149,
      5,
      7,
      NULL,
      8.160132,
      NULL,
      1.520666,
      1.507227,
      117,
      1,
      NULL,
      185,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-29-1992',
      NULL,
      103,
      78.050325,
      NULL,
      18,
      NULL,
      93,
      NULL,
      3,
      75,
      53.103246,
      54.787424,
      ' 7-18-1975',
      31,
      8.470568,
      4,
      63.893005,
      93.415311,
      130,
      NULL,
      NULL,
      21,
      3,
      ' 6-23-2003',
      NULL,
      19.196236,
      3,
      14,
      NULL,
      NULL,
      1.640338,
      1,
      0.307986,
      70,
      1.116068,
      NULL,
      2,
      14,
      1.791331,
      0.764630,
      1,
      1.322080,
      ' 1- 3-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      12.962450,
      ' 1-14-1981',
      15.410877,
      NULL,
      NULL,
      19,
      ' 8- 0-1986',
      3,
      2.235256,
      ' 8- 0-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      ' 5- 5-1985',
      56.824169,
      NULL,
      13,
      '11-24-1993',
      1,
      110,
      '11-24-1992',
      5.075399,
      60,
      22.572371,
      24.953470,
      NULL,
      62,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


