set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '02144000',
      '20004104',
      '24204010',
      NULL,
      NULL,
      '33313114',
      '12041401',
      '21324320',
      '04111331',
      '10341310',
      '13323022',
      '11420403',
      '44124332',
      '01324312',
      '41411023',
      '24312342',
      '21443131',
      '04102303',
      '04223134',
      '22220302',
      NULL,
      '04143431',
      '00201132',
      '13341413',
      '24310143',
      '24043043',
      '40001001',
      '21331334',
      '32334024',
      '34414143',
      '32120344',
      '14224344',
      '32021041',
      '44331310',
      '42102443',
      '34213120',
      NULL,
      '34221242',
      '42230042',
      NULL,
      '24442122',
      '41440123',
      '42302222',
      '',
      NULL,
      NULL,
      NULL,
      '4433133',
      1,
      1,
      NULL,
      NULL,
      '330432',
      1.864496,
      ' 7- 7-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      15.284879,
      17.341529,
      0.232178,
      3,
      2.308636,
      5.424669,
      7.628323,
      10,
      15.793613,
      2.749394,
      9.560772,
      3.316512,
      13.246088,
      1.269420,
      4.860910,
      40.328036,
      14.471521,
      NULL,
      14,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      55,
      113,
      41.061203,
      53.312893,
      ' 2- 7-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      14.376996,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821544,
      1.531679,
      2.890121,
      3,
      1,
      1.802829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-25-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1984',
      28,
      0,
      18.817666,
      78,
      70.903074,
      27,
      NULL,
      NULL,
      2,
      0.789662,
      NULL,
      60.551719,
      ' 2-16-1982',
      13.462493,
      30,
      NULL,
      47.310513,
      68.491772,
      81.703231,
      4,
      ' 7-29-2003',
      1.133286,
      1.654758,
      ' 0-24-1978',
      11,
      7.629821,
      NULL,
      12.439356,
      4.354109,
      6.485291,
      NULL,
      7,
      NULL,
      57.779015,
      1,
      3.901557,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-24-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.685586,
      28,
      NULL,
      ' 6- 9-1981',
      0.149985,
      NULL,
      ' 5-25-2003',
      7.955718,
      5.252771,
      18.135165,
      5.015480,
      ' 0- 0-1980',
      10.644411,
      0.568788,
      142,
      '11- 0-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      2.262343,
      21,
      NULL,
      7.208958,
      NULL,
      45.515616,
      9.970594,
      40,
      2,
      13.526414,
      66,
      0,
      NULL,
      98,
      3,
      2.023851,
      64,
      NULL,
      NULL,
      84,
      2,
      20,
      552.276946,
      1.762788,
      NULL,
      69.896942,
      0.406909,
      NULL,
      0,
      0.379610,
      0,
      NULL,
      0.535710,
      1.445128,
      0,
      31,
      53,
      1,
      23.529193,
      57,
      NULL,
      5.254622,
      NULL,
      0.608386,
      5,
      4.219799,
      NULL,
      NULL,
      27,
      0.103898,
      42.096221,
      0,
      0,
      59,
      23,
      1.684596,
      NULL,
      20.062769,
      12,
      NULL,
      68.771310,
      NULL,
      1,
      1.880857,
      1.656880,
      0.948869,
      1,
      1,
      0,
      45.930674,
      NULL,
      ' 0-10-1981',
      '11-24-1992',
      '10-11-1975',
      ' 1-10-1981',
      ' 3-20-1977',
      NULL,
      NULL);
commit;
end;
/


