set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1344',
      NULL,
      '42444404',
      '22312011',
      '01341132',
      '30304203',
      NULL,
      NULL,
      '11322010',
      '03401403',
      '10221140',
      '10011142',
      '31223312',
      '41444020',
      '40014233',
      '33404312',
      '43012232',
      '22300220',
      '24324340',
      '44403124',
      '31304420',
      '20123343',
      '44144243',
      '12420210',
      NULL,
      '04432401',
      '31441222',
      '41342324',
      '30101132',
      '32110402',
      '13412412',
      NULL,
      NULL,
      '20001044',
      '44434314',
      '31420321',
      '33321214',
      '34134144',
      NULL,
      '13441002',
      '32323314',
      '04141422',
      NULL,
      NULL,
      NULL,
      '403',
      '40',
      NULL,
      NULL,
      '0334440',
      1,
      114,
      NULL,
      NULL,
      '304020',
      2.901492,
      ' 5- 7-1981',
      ' 1-13-1991',
      NULL,
      NULL,
      38,
      NULL,
      10.612558,
      7.611013,
      NULL,
      NULL,
      9,
      NULL,
      19,
      NULL,
      24,
      7,
      33,
      11,
      24.101031,
      17.653020,
      64.272250,
      19.909857,
      2.967016,
      NULL,
      57.535262,
      9,
      1,
      92.204349,
      41.471018,
      72.443514,
      164,
      150.807114,
      114,
      '10- 5-1996',
      NULL,
      25,
      0,
      16,
      98,
      124.527444,
      ' 8-23-2003',
      NULL,
      NULL,
      7.144264,
      0.251466,
      8,
      1,
      3.593007,
      5,
      0,
      1.085446,
      0.927022,
      0.803076,
      0,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      4.395902,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-15-1994',
      93,
      15.688879,
      15.522513,
      3.841541,
      7,
      5.203206,
      ' 1- 1-1989',
      1.332132,
      1,
      30,
      0.659158,
      1,
      52.208761,
      1,
      1.663173,
      6,
      NULL,
      NULL,
      NULL,
      ' 1-15-1987',
      19.946194,
      12,
      18,
      32,
      15,
      9,
      52.178269,
      NULL,
      36.998634,
      92,
      0,
      30.027774,
      ' 7- 2-1982',
      3,
      NULL,
      6.040384,
      30,
      10,
      NULL,
      5,
      '10-15-1993',
      2.201826,
      10.999928,
      ' 4- 6-1996',
      4,
      NULL,
      2,
      25.315168,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      22,
      0.326977,
      3.810093,
      5.851996,
      1.600228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      112.765525,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      38.103130,
      NULL,
      23,
      '11-14-2003',
      9,
      13.099461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 1-21-1987',
      NULL,
      NULL,
      NULL,
      1,
      0,
      15,
      ' 8-10-1978',
      59.989414,
      42.360385,
      27.847097,
      '11-10-2003',
      NULL,
      107,
      ' 3- 4-1984',
      4.425106,
      47.459338,
      23.751916,
      15.828001,
      ' 4- 4-2002',
      65.933984,
      NULL,
      68.475889,
      ' 6-20-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


