set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4322',
      NULL,
      '04131311',
      NULL,
      '14244103',
      '40423331',
      NULL,
      '44420321',
      '41113441',
      '00133010',
      '23402411',
      '32413343',
      '13131204',
      '40034032',
      '02213442',
      NULL,
      '41241011',
      NULL,
      '04004234',
      '14104433',
      '12101323',
      '11213420',
      '42440212',
      '04344344',
      '02403420',
      '41213132',
      '12423040',
      '10420022',
      NULL,
      '23143424',
      '03300304',
      NULL,
      NULL,
      '04220000',
      '22402134',
      '31143202',
      NULL,
      '42132301',
      '13410430',
      '44003202',
      NULL,
      '41404323',
      '42044214',
      '11423401',
      '00001041',
      '334',
      '33',
      NULL,
      13.639512,
      '3310314',
      NULL,
      172,
      NULL,
      NULL,
      '331024',
      3.418831,
      ' 6-20-1976',
      ' 7- 7-2003',
      NULL,
      44.721525,
      NULL,
      10.396820,
      NULL,
      4.805771,
      83,
      NULL,
      8.285018,
      0.885588,
      NULL,
      NULL,
      22.369960,
      18.416628,
      25.827484,
      5,
      7,
      16,
      9.906770,
      19.505835,
      10,
      18,
      18,
      9.896232,
      0,
      99,
      5,
      0,
      118,
      49.677637,
      NULL,
      ' 1-14-1991',
      8.560605,
      6.129986,
      35,
      20,
      15.695987,
      179.610498,
      ' 6-15-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74,
      14.373227,
      8,
      0.299922,
      5,
      6,
      ' 0-23-1974',
      1.930085,
      NULL,
      24,
      NULL,
      NULL,
      31.888341,
      1.895311,
      2.299875,
      16.111109,
      NULL,
      NULL,
      NULL,
      NULL,
      47.543484,
      7.868738,
      29,
      24,
      9,
      32,
      94.687460,
      1,
      NULL,
      17.820939,
      65.680073,
      NULL,
      ' 6- 6-1996',
      2.635632,
      0,
      14,
      32.678054,
      5.666885,
      84,
      NULL,
      ' 9-23-1997',
      21,
      6.869211,
      '11- 6-2002',
      7,
      7,
      NULL,
      5.090704,
      NULL,
      5.811866,
      NULL,
      1,
      0.219194,
      32.699200,
      9,
      3,
      5,
      2.458751,
      10.948437,
      8.856373,
      1.677472,
      NULL,
      ' 4-23-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      133,
      0,
      ' 5-24-1993',
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      39,
      ' 9-14-1992',
      9,
      NULL,
      ' 6- 5-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      ' 5- 8-1986',
      51.205052,
      17.438326,
      4.010065,
      ' 9-19-1986',
      NULL,
      139,
      ' 2-19-1997',
      1.176464,
      22.875495,
      0.377140,
      39.303879,
      ' 9- 9-1981',
      61,
      1.471806,
      113,
      ' 6-23-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


