set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7129368';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3114',
      NULL,
      '44331133',
      '02312130',
      '03042411',
      '42441102',
      '02001140',
      NULL,
      NULL,
      NULL,
      '00213400',
      '03331140',
      NULL,
      '33141203',
      '31041230',
      '04403344',
      '02412133',
      '10024432',
      '23101142',
      '10034204',
      '22132134',
      '44314442',
      '21132131',
      '03342433',
      '30444230',
      NULL,
      '30432301',
      '22122421',
      '32012414',
      NULL,
      '22200402',
      '10214240',
      '31130040',
      '40101031',
      '43223001',
      '40021101',
      '01120421',
      '03334031',
      '22004101',
      '43130141',
      '31312330',
      NULL,
      '20101304',
      '00230214',
      '00321422',
      '020',
      '43',
      NULL,
      NULL,
      '4142043',
      1,
      0,
      1,
      NULL,
      NULL,
      5.484028,
      '11- 9-1997',
      ' 3-11-1994',
      NULL,
      NULL,
      41.152771,
      NULL,
      36.136662,
      NULL,
      33,
      8,
      24.470724,
      NULL,
      18,
      NULL,
      7,
      8,
      NULL,
      NULL,
      36,
      2.715671,
      38.987380,
      25,
      5.604635,
      9.405807,
      NULL,
      8.057815,
      0,
      90,
      140.330833,
      NULL,
      NULL,
      204,
      133,
      ' 7-11-1979',
      NULL,
      NULL,
      31.375405,
      33,
      180.643525,
      38,
      ' 9- 4-1978',
      NULL,
      NULL,
      1,
      0,
      0.969596,
      NULL,
      NULL,
      5.885045,
      1.524319,
      0,
      0.876588,
      0.666301,
      NULL,
      NULL,
      0,
      1,
      1.381826,
      1.369453,
      1.300020,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-15-1993',
      46.489794,
      29,
      1,
      4,
      8.674284,
      1,
      NULL,
      0.142053,
      5.176833,
      82,
      1,
      2.259656,
      123.745195,
      1,
      0.037185,
      1.788522,
      0.476563,
      0,
      161.779325,
      ' 7- 3-1983',
      2,
      6.657791,
      NULL,
      112,
      97,
      37.490219,
      69,
      56,
      75,
      51.760583,
      94,
      9,
      ' 0-28-1980',
      28.122693,
      13,
      17,
      28,
      42.782519,
      85.502547,
      1,
      '11- 7-1994',
      18,
      NULL,
      NULL,
      7,
      26,
      6.410023,
      7,
      12.498207,
      4,
      1,
      2,
      0,
      106.734091,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      11,
      3.036113,
      NULL,
      ' 0-22-1991',
      252,
      0,
      '11-22-1977',
      53.414737,
      9.110814,
      '11-23-1979',
      3,
      ' 0- 3-1996',
      9.894320,
      ' 5-13-2003',
      19,
      NULL,
      '10- 7-1996',
      NULL,
      NULL,
      NULL,
      4.823141,
      2.276156,
      ' 7-21-1978',
      3,
      1,
      ' 4- 0-1974',
      1,
      NULL,
      14.177824,
      ' 9- 0-1991',
      37,
      NULL,
      50.441762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


