set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9328178';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0342',
      '33233142',
      '31001141',
      '11333444',
      NULL,
      '41103104',
      NULL,
      '44441320',
      '34440324',
      NULL,
      '14324023',
      NULL,
      '13442010',
      '30324000',
      '24421313',
      NULL,
      '31212200',
      '34234124',
      '34022412',
      '24003402',
      NULL,
      '32240121',
      '12223111',
      '32341243',
      '22314300',
      '22311334',
      '34333200',
      NULL,
      '34103110',
      '42232011',
      '41010440',
      NULL,
      '41432132',
      '40232420',
      '12414012',
      '11423022',
      '40133212',
      '01113234',
      '43233321',
      '24121000',
      '33434311',
      '41341111',
      '31242020',
      '21444441',
      '24131120',
      '014',
      '44',
      NULL,
      14,
      '0114041',
      0.830906,
      0.920612,
      NULL,
      NULL,
      '442243',
      1,
      '11- 8-1995',
      ' 0-24-1994',
      80.636999,
      21,
      34,
      NULL,
      NULL,
      8.046874,
      103.376534,
      21.625344,
      29.104063,
      25,
      11,
      12,
      NULL,
      7,
      16.133815,
      1.404630,
      10.168109,
      NULL,
      NULL,
      15,
      4,
      3.064445,
      36,
      5,
      0.781640,
      100.167672,
      165,
      23,
      23,
      57,
      3.284934,
      ' 2- 8-1997',
      NULL,
      17.984494,
      10,
      4,
      133.786206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.457237,
      NULL,
      ' 6- 6-1998',
      1,
      NULL,
      67.128535,
      0.161282,
      3.131827,
      NULL,
      0.214253,
      4.082548,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-18-1986',
      49,
      NULL,
      109.400119,
      78.248249,
      50,
      80,
      NULL,
      0.000688,
      9.527745,
      27.539211,
      56,
      30,
      ' 3-14-1993',
      NULL,
      24.770199,
      NULL,
      67.720699,
      121.049083,
      82.518956,
      10,
      ' 9-25-1974',
      43.852578,
      25,
      ' 6-22-1981',
      5,
      21.634652,
      2.396986,
      8.567084,
      2,
      0.407867,
      0.300552,
      12.468533,
      1,
      87.327515,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      0.283401,
      1.136324,
      0.534597,
      ' 3- 2-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      149,
      0,
      ' 2-12-1984',
      NULL,
      NULL,
      NULL,
      24.252511,
      ' 5- 8-1998',
      33.580474,
      NULL,
      14.806486,
      9.927903,
      ' 5-26-1980',
      100.554008,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      ' 7- 6-1994',
      NULL,
      38.480477,
      12,
      NULL,
      2,
      NULL,
      ' 1- 0-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


