set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9121461';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21140002',
      NULL,
      '43132041',
      '33104040',
      '33041023',
      '24133200',
      '10314124',
      NULL,
      '21410333',
      '03124311',
      '31441001',
      '02410014',
      '34113312',
      NULL,
      '13413014',
      NULL,
      '10040143',
      '41310443',
      '31314133',
      '41211021',
      '22140434',
      NULL,
      '30112211',
      '34414223',
      '34112134',
      '13444210',
      NULL,
      '01301112',
      NULL,
      '41024221',
      '24331244',
      '23342434',
      '43424440',
      '12241203',
      '00302314',
      '32342232',
      NULL,
      '41233104',
      '01000204',
      '41320312',
      '43300424',
      '20111301',
      NULL,
      '31111113',
      '243',
      '13',
      NULL,
      NULL,
      '2421301',
      0,
      0,
      1,
      NULL,
      '213313',
      5.310949,
      NULL,
      ' 5-19-1998',
      53,
      NULL,
      22.345350,
      1,
      46.125332,
      9.934541,
      12.715160,
      NULL,
      26,
      9,
      15,
      13.554033,
      NULL,
      NULL,
      10,
      NULL,
      30,
      NULL,
      0,
      16,
      NULL,
      NULL,
      101.528613,
      NULL,
      NULL,
      82,
      212.261488,
      27.475104,
      223,
      89.561743,
      106,
      ' 0-17-1996',
      62,
      6.659172,
      2,
      NULL,
      NULL,
      159,
      ' 0-28-1981',
      1.047395,
      0.465200,
      1.583720,
      1,
      1,
      0,
      1,
      NULL,
      1.125879,
      1,
      NULL,
      NULL,
      1.679581,
      0,
      0.892040,
      1.956624,
      1.490277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 6-1999',
      91.694945,
      3.460662,
      16.250643,
      7,
      12,
      1.675016,
      ' 0-13-1984',
      1.720833,
      NULL,
      45.397987,
      1,
      1,
      16,
      1,
      0,
      NULL,
      1,
      1.567058,
      151.292496,
      '11-14-1991',
      67.394021,
      37,
      51,
      22,
      NULL,
      74.748258,
      27,
      10,
      37,
      49,
      40.734271,
      40.001472,
      ' 8-22-2001',
      NULL,
      NULL,
      7,
      103.697616,
      NULL,
      170,
      4.796431,
      ' 3-22-2001',
      30,
      25.466744,
      NULL,
      14.409578,
      8,
      NULL,
      4,
      6.123791,
      19,
      0.693112,
      11.569978,
      0.368176,
      24.497388,
      0,
      NULL,
      2.617244,
      13,
      1,
      0,
      0.226677,
      0,
      ' 9-22-1990',
      4.420278,
      0,
      9.774803,
      NULL,
      18,
      4,
      NULL,
      33,
      3,
      '10-16-1995',
      NULL,
      ' 0- 6-1974',
      35.462961,
      ' 3- 4-1995',
      17,
      NULL,
      ' 8- 4-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      4.398273,
      ' 9-12-1987',
      0,
      8,
      ' 9- 0-1993',
      0,
      3,
      16.002463,
      ' 4- 8-2002',
      28,
      NULL,
      12.377634,
      '10- 8-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.919503);
commit;
end;
/


