set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9237310';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4213',
      '31114014',
      '33020131',
      '23312203',
      '01433021',
      '22132342',
      NULL,
      '03004302',
      '21200131',
      '13011212',
      '33422410',
      '10242204',
      '14203022',
      '22204214',
      '22022120',
      '31004040',
      '20302130',
      NULL,
      NULL,
      '41342440',
      '24221320',
      '23410414',
      NULL,
      NULL,
      '44441013',
      NULL,
      '32443044',
      '12213021',
      '13001432',
      '04042004',
      '43300123',
      '03210214',
      '23332204',
      NULL,
      '43110110',
      '42141324',
      '31032011',
      NULL,
      '04302430',
      '33302111',
      '24031424',
      '04041313',
      '43400330',
      '40443304',
      '22341041',
      '040',
      '40',
      NULL,
      NULL,
      '3412001',
      1.738924,
      NULL,
      0,
      NULL,
      '000203',
      1,
      ' 0-21-1975',
      ' 1-10-1992',
      20.759049,
      NULL,
      21,
      NULL,
      18.440913,
      NULL,
      25,
      0,
      5,
      24.681205,
      4,
      0,
      4,
      5.609870,
      9.256717,
      0.547817,
      19.303564,
      NULL,
      57,
      17,
      28,
      NULL,
      26,
      13.960193,
      0.401733,
      109,
      180,
      88.849128,
      195.561426,
      239,
      NULL,
      NULL,
      49,
      66,
      18.921864,
      NULL,
      171,
      123,
      ' 7-25-1979',
      NULL,
      2.165661,
      1,
      1,
      NULL,
      3,
      NULL,
      0.477626,
      NULL,
      1,
      NULL,
      1.741919,
      0,
      0.786123,
      0.188109,
      0,
      0,
      0,
      1,
      0.909744,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 9-1976',
      51.581619,
      10,
      10,
      2,
      4.454177,
      3.554015,
      ' 7-29-1994',
      0.618258,
      1,
      NULL,
      1.329102,
      4,
      36,
      2,
      3,
      94.559143,
      1.610385,
      1.270234,
      225,
      NULL,
      97,
      85,
      80,
      85.158918,
      125.341650,
      102.882724,
      19.134711,
      97,
      97,
      73,
      43,
      79,
      ' 6- 6-1999',
      22.052950,
      NULL,
      NULL,
      21.469696,
      3.810567,
      74,
      8,
      ' 9-20-1989',
      18.671025,
      14,
      ' 2-22-2001',
      3.298631,
      15.528279,
      11,
      6.099916,
      12,
      1,
      1.397354,
      NULL,
      1.806453,
      100.397110,
      0.766397,
      0,
      1,
      18,
      1.104996,
      0,
      NULL,
      0.995474,
      ' 4-22-1994',
      NULL,
      1,
      2,
      '10-17-1996',
      60,
      NULL,
      ' 5- 2-1998',
      38,
      2.613291,
      ' 6-10-1979',
      52.922988,
      ' 2- 6-1978',
      NULL,
      ' 0- 8-1990',
      NULL,
      11,
      ' 9- 0-1983',
      67,
      20,
      ' 3-22-1996',
      11,
      NULL,
      ' 4- 0-1991',
      NULL,
      2.711845,
      ' 4-29-2000',
      1,
      3,
      19,
      ' 7-20-1985',
      45,
      12,
      49,
      ' 3-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11);
commit;
end;
/


