set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9853968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      '4',
      '0',
      '2',
      '1',
      '0',
      '3',
      '2',
      '2',
      '2',
      NULL,
      '0',
      '3',
      '1',
      '2',
      '4',
      '3',
      '2',
      NULL,
      '0',
      '1',
      NULL,
      '',
      '1',
      '',
      NULL,
      '4',
      '0',
      '2',
      '2',
      '',
      NULL,
      NULL,
      '2',
      '1',
      '3',
      '1',
      '4',
      NULL,
      '0',
      '2',
      '3',
      '3',
      '102',
      '30441103',
      21,
      39,
      '3011332',
      3.740447,
      0,
      NULL,
      NULL,
      '334034',
      1,
      ' 6-17-1979',
      ' 9- 5-1990',
      NULL,
      145.261223,
      NULL,
      22.457570,
      18.754195,
      21,
      NULL,
      18.438958,
      NULL,
      NULL,
      6.531697,
      12,
      20.613353,
      NULL,
      NULL,
      2.572621,
      16.972860,
      14,
      8,
      21.448536,
      31,
      8.603690,
      94,
      NULL,
      0.981200,
      NULL,
      48.663038,
      NULL,
      188,
      250,
      71,
      NULL,
      NULL,
      43,
      1.149372,
      6.776380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.053530,
      21,
      0.282928,
      1.848165,
      1.405206,
      2.340541,
      ' 7- 6-1992',
      1,
      0.641790,
      126.804819,
      1.020987,
      NULL,
      42,
      0.747776,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      '11-10-1981',
      78.935807,
      42.616233,
      NULL,
      NULL,
      NULL,
      103,
      NULL,
      NULL,
      38,
      9,
      87.916643,
      84.487472,
      ' 7-21-1992',
      33.307016,
      13,
      38.104921,
      85.100463,
      110,
      95.579513,
      10,
      NULL,
      18.788640,
      1,
      NULL,
      NULL,
      13.949405,
      NULL,
      1.898670,
      22,
      NULL,
      0,
      7.258023,
      1.610625,
      112.928321,
      NULL,
      1,
      12,
      NULL,
      1,
      NULL,
      0,
      NULL,
      ' 4-21-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      88.585142,
      NULL,
      ' 5-28-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-29-2002',
      NULL,
      13,
      '10-17-1990',
      33.868988,
      NULL,
      ' 7-17-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      4.884668,
      ' 4-11-1979',
      36,
      23.769555,
      7.240439,
      ' 4-29-2002',
      4,
      NULL,
      ' 9-18-1992',
      NULL,
      NULL,
      NULL,
      20,
      ' 9-24-1992',
      66,
      1.982363,
      40,
      ' 2-23-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


