set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8927646';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4222',
      '14341014',
      '13124124',
      '01140200',
      '40403322',
      '32410002',
      '11232214',
      '43441313',
      '33311204',
      '21032301',
      '34304210',
      '33331201',
      '04432302',
      '34200014',
      '10304402',
      '33400213',
      '04130403',
      '40412310',
      '33101102',
      '03011034',
      '21140332',
      NULL,
      '20431400',
      NULL,
      '13430424',
      '23004142',
      '32323221',
      '31202443',
      '44003410',
      NULL,
      '30030343',
      '34120024',
      '01410314',
      '03414322',
      '42200200',
      '32342100',
      NULL,
      '21310334',
      '01003310',
      '23042030',
      '43330001',
      '34410300',
      '01123434',
      '10201042',
      '00411301',
      '',
      '',
      NULL,
      NULL,
      '2411220',
      1,
      1,
      2,
      NULL,
      '102241',
      3.929392,
      '11- 4-1978',
      ' 3-24-1989',
      24.539299,
      NULL,
      NULL,
      10.981007,
      1.622148,
      16,
      70.281427,
      6.836658,
      6,
      NULL,
      8.608918,
      NULL,
      NULL,
      10.034256,
      NULL,
      15,
      2,
      5,
      91.715472,
      NULL,
      59.229158,
      NULL,
      121.060992,
      7,
      NULL,
      45.822816,
      105,
      NULL,
      114,
      NULL,
      NULL,
      '10-12-1993',
      2.945512,
      NULL,
      11,
      11.614407,
      NULL,
      209,
      NULL,
      1.055576,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.453760,
      1,
      NULL,
      5.417247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-28-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-1981',
      56.775256,
      101,
      76,
      112,
      55.946212,
      20.681007,
      11,
      59.095412,
      NULL,
      62.073475,
      NULL,
      27.988146,
      ' 6- 9-1997',
      12,
      20,
      NULL,
      16,
      80.889966,
      46,
      0,
      '11-26-1992',
      6,
      NULL,
      NULL,
      6,
      NULL,
      2.067943,
      13,
      0,
      5,
      NULL,
      11.154576,
      NULL,
      65,
      3.260325,
      1,
      14.630053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-14-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.931675,
      27,
      ' 4-15-1990',
      1,
      34,
      ' 7-23-1995',
      NULL,
      NULL,
      11,
      NULL,
      ' 5-18-1999',
      62,
      1,
      29,
      '10-11-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      121.433489,
      159.292506,
      NULL,
      NULL,
      79.878465,
      13,
      0.218232,
      NULL,
      5.631306,
      NULL,
      NULL,
      0.998614,
      1.309003,
      7.573212,
      0.801383,
      2,
      22.658442,
      NULL,
      2,
      42,
      1.459740,
      NULL,
      96,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0.110729,
      1,
      NULL,
      NULL,
      NULL,
      14.804468,
      NULL,
      NULL,
      1,
      3.026013,
      1.279152,
      1.110718,
      1.442732,
      3.633363,
      10.704279,
      NULL,
      NULL,
      2,
      NULL,
      1.317021,
      NULL,
      NULL,
      32.533939,
      9.034335,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      0.931828,
      NULL,
      1.075361,
      NULL,
      0,
      1,
      0,
      0.377023,
      NULL,
      '10-16-2000',
      ' 4- 2-1990',
      '10- 5-1991',
      ' 2-26-1978',
      '10-23-1980',
      ' 0-24-1976',
      ' 0- 8-1989',
      NULL);
commit;
end;
/


