set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8901750';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2002',
      '14120334',
      '31030132',
      '33324104',
      NULL,
      NULL,
      '20212242',
      '13323324',
      '10020402',
      '03114433',
      '31011434',
      '41233041',
      '02323342',
      '11324233',
      '13411441',
      '03003201',
      '11023222',
      '42403232',
      '11033344',
      '00302402',
      '32140034',
      '00011202',
      NULL,
      '30231302',
      '02210414',
      '21042122',
      '03220101',
      '00144213',
      '02343104',
      '23102212',
      '01203311',
      NULL,
      '04202001',
      '13103332',
      '21342204',
      '33020440',
      '13044140',
      '14112342',
      '01002424',
      '22424304',
      NULL,
      '00421240',
      '43310001',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      '443011',
      NULL,
      ' 3-19-1989',
      ' 8-19-1988',
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      1.321504,
      NULL,
      23,
      210.978892,
      NULL,
      '10-29-1998',
      1.395017,
      0.985068,
      1.356768,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740178,
      1.618128,
      19,
      1.975700,
      1,
      0.330114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-16-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-15-1996',
      55.824204,
      61.326502,
      NULL,
      5.763585,
      31,
      16,
      31.753862,
      44.933117,
      2.976262,
      NULL,
      42.583007,
      35,
      ' 2- 6-1992',
      16.007836,
      37.698085,
      2,
      7,
      124,
      169,
      NULL,
      ' 6-25-1997',
      NULL,
      3,
      ' 1-19-1990',
      6.393519,
      NULL,
      20,
      18,
      7.248856,
      11,
      NULL,
      11.645781,
      NULL,
      152,
      17.661663,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-16-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      7,
      22.870273,
      ' 5-22-1999',
      NULL,
      86.138826,
      ' 7-20-2001',
      6,
      13.916639,
      12.786619,
      24,
      ' 3- 9-1995',
      18,
      1.172438,
      113,
      ' 4- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533052,
      0,
      30.866535,
      1,
      1,
      7.616599,
      3.603703,
      0.534743,
      96.710634,
      2.745251,
      0,
      74.171649,
      NULL,
      31,
      NULL,
      1.519615,
      NULL,
      1.358887,
      NULL,
      1.263492,
      1.299682,
      1.810103,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.862279,
      NULL,
      30.307790,
      5.511186,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      11.957621,
      NULL,
      1,
      2,
      0,
      1.810660,
      1,
      0,
      NULL,
      NULL,
      NULL,
      ' 3-15-1997',
      NULL,
      ' 9-26-1996',
      NULL,
      '11-26-2003',
      NULL);
commit;
end;
/


