set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716130';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '2',
      '4',
      '3',
      '2',
      '0',
      '1',
      '0',
      '4',
      '1',
      '3',
      '1',
      '3',
      '3',
      '2',
      '3',
      '1',
      '2',
      NULL,
      '3',
      NULL,
      '2',
      NULL,
      '',
      '2',
      '',
      '2',
      NULL,
      '2',
      '4',
      NULL,
      '',
      '',
      '2',
      '3',
      '4',
      NULL,
      '4',
      '4',
      '0',
      '4',
      '1',
      '1',
      '4',
      '131',
      '02011204',
      NULL,
      43.755020,
      NULL,
      3,
      1,
      1,
      NULL,
      '332340',
      0,
      NULL,
      ' 0-19-1983',
      14.681289,
      244.933544,
      22,
      5,
      20,
      NULL,
      NULL,
      NULL,
      6.216847,
      NULL,
      9.841339,
      6.083465,
      42,
      2.480420,
      7,
      NULL,
      8,
      11.170472,
      39,
      NULL,
      23.281508,
      6.061149,
      90.059611,
      5.806552,
      1,
      53.757800,
      160,
      NULL,
      102.864323,
      NULL,
      110.481903,
      ' 0-11-1986',
      46.638396,
      22,
      NULL,
      23.705721,
      22.936313,
      163,
      ' 7-15-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.083500,
      NULL,
      3,
      NULL,
      9.208258,
      3.388550,
      NULL,
      0.411298,
      1.992777,
      192,
      0.938901,
      0.808300,
      NULL,
      1,
      0.826885,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1979',
      14,
      19,
      22,
      NULL,
      NULL,
      49,
      51.412754,
      25.868057,
      26.303265,
      26,
      4.659017,
      14,
      '11-14-2002',
      0,
      13,
      NULL,
      24,
      6,
      5,
      7.166380,
      ' 0-20-1978',
      11,
      9,
      ' 6- 3-1980',
      1.455213,
      3.308959,
      8,
      12.419526,
      NULL,
      6,
      1,
      NULL,
      0,
      1.798693,
      0,
      0,
      5,
      16,
      0,
      0,
      1.035216,
      1,
      ' 5-17-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      ' 9-20-1977',
      NULL,
      ' 0-23-1985',
      9,
      3.837216,
      ' 0-11-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      27.550724,
      1.447688,
      0.404298,
      ' 3-18-1992',
      3.093211,
      45.623230,
      NULL,
      10.536869,
      51,
      10.454737,
      55,
      ' 0- 8-1992',
      39.236760,
      1.482309,
      100.167044,
      '10-14-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


