set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716130';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '4',
      '0',
      '2',
      '2',
      '1',
      '3',
      '1',
      '2',
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '2',
      '2',
      '2',
      '0',
      '4',
      NULL,
      '1',
      '4',
      '4',
      '',
      '1',
      NULL,
      '0',
      '3',
      '3',
      '2',
      '2',
      '',
      '',
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4',
      '0',
      '4',
      '4',
      '2',
      '1',
      '020',
      '14323421',
      NULL,
      50,
      '0000031',
      2,
      NULL,
      0,
      NULL,
      NULL,
      5.748334,
      ' 2-25-1987',
      NULL,
      295.171544,
      97.827764,
      17.980836,
      18.212116,
      8.070881,
      13,
      9,
      14,
      12.424744,
      17,
      18.854306,
      1.626716,
      38.797964,
      NULL,
      18,
      9,
      21.675671,
      11,
      14,
      NULL,
      NULL,
      NULL,
      86.824246,
      NULL,
      0.110757,
      9,
      102,
      78.290782,
      6.027896,
      NULL,
      NULL,
      '10-18-1986',
      NULL,
      2.618756,
      7,
      NULL,
      NULL,
      193,
      ' 1- 7-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      17,
      16,
      NULL,
      16.268863,
      NULL,
      ' 9- 8-1998',
      1,
      3,
      83,
      1,
      NULL,
      28,
      1.450412,
      3.640894,
      56,
      NULL,
      NULL,
      NULL,
      ' 2- 6-1977',
      84.668809,
      90,
      18,
      19,
      NULL,
      7,
      93.187853,
      63.847501,
      NULL,
      15.210095,
      60.470935,
      43.246887,
      NULL,
      12,
      0.745926,
      NULL,
      26,
      19,
      0,
      9,
      ' 9-12-1977',
      0.247946,
      6.791358,
      ' 8- 4-1975',
      8.880947,
      2.520039,
      20,
      21,
      2.797450,
      9,
      1.313270,
      16,
      0,
      47.320785,
      1,
      NULL,
      19.061213,
      6,
      3,
      NULL,
      1,
      0.714714,
      ' 8-20-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 3- 8-1974',
      NULL,
      NULL,
      NULL,
      30.669761,
      ' 1- 5-1988',
      NULL,
      ' 8-28-2001',
      17,
      2.883300,
      NULL,
      129.242377,
      NULL,
      ' 2-20-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.602758,
      ' 6-14-1978',
      27,
      3.575340,
      NULL,
      ' 6- 5-1987',
      1,
      122.084400,
      NULL,
      0,
      NULL,
      4,
      15,
      ' 8-28-1975',
      28.173895,
      0.269555,
      68,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


