set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9001500';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2334',
      '43143033',
      '00431320',
      '03141320',
      '21043003',
      NULL,
      '31312023',
      '00012042',
      '10310210',
      NULL,
      '01330342',
      '04003101',
      '24344433',
      '42221444',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21413320',
      '24431442',
      '01144244',
      '02020040',
      NULL,
      NULL,
      NULL,
      NULL,
      '42014024',
      '12224330',
      '31011230',
      '01322123',
      '23402421',
      '03204434',
      '01403140',
      '32420334',
      '32443433',
      NULL,
      '40003220',
      '44000231',
      '44101004',
      '31410102',
      '03332400',
      '32220031',
      '10143123',
      '02104323',
      '101',
      '22',
      NULL,
      NULL,
      '2321443',
      2,
      1,
      2,
      NULL,
      '212100',
      2,
      ' 4-24-1993',
      ' 9-16-1986',
      25.242162,
      NULL,
      26.218594,
      14,
      21.472612,
      10.106107,
      59.878257,
      24,
      10.366383,
      10.671692,
      NULL,
      38,
      36.999961,
      29.835122,
      20.189460,
      3,
      14.496903,
      4,
      97.093500,
      20.231577,
      81.098062,
      11.847525,
      141,
      12.980992,
      0,
      179.642011,
      159,
      NULL,
      NULL,
      64,
      3.892914,
      ' 8- 0-1989',
      19.151678,
      0,
      29,
      5.031799,
      136.314590,
      193,
      ' 5-15-1979',
      1,
      2,
      NULL,
      1.673978,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.764189,
      NULL,
      1.117195,
      0,
      1.776585,
      0.270098,
      0.045864,
      1,
      0.613004,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-10-2002',
      101.202830,
      17.597699,
      3.961387,
      NULL,
      5.618824,
      1.402485,
      ' 1-11-1992',
      0.797695,
      NULL,
      69,
      1.605754,
      NULL,
      168.142701,
      0,
      1,
      76.588654,
      0.776136,
      NULL,
      172.507607,
      ' 0-27-2003',
      18,
      12.945904,
      74.136746,
      NULL,
      70.289381,
      NULL,
      59,
      112,
      19,
      49,
      NULL,
      86,
      ' 8-23-2002',
      48.487451,
      41,
      14.846656,
      49,
      58,
      105,
      13,
      ' 7-24-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      1.384014,
      NULL,
      ' 6-10-2001',
      173,
      3,
      NULL,
      23,
      3,
      NULL,
      47,
      ' 0- 4-1981',
      39.812719,
      ' 1- 2-1984',
      8.736321,
      14,
      ' 8- 6-2003',
      100.184051,
      87,
      ' 5- 3-1986',
      2.353085,
      7,
      ' 7- 8-1981',
      0.773038,
      1.466401,
      '10-23-1991',
      2,
      0,
      27,
      ' 5-11-1974',
      39,
      19.665573,
      34,
      ' 9-12-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


