set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226283';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2201',
      '42130342',
      '03130011',
      '11211312',
      '03123104',
      '21341103',
      '33302420',
      '30403132',
      '22243013',
      '33212210',
      '11011203',
      '02322013',
      '20214143',
      '01431200',
      '23323430',
      '21224443',
      '32341210',
      '21240123',
      '01334414',
      NULL,
      '31044210',
      '30322100',
      NULL,
      '44244301',
      '33204212',
      NULL,
      '12240042',
      '04203002',
      '31424420',
      NULL,
      '30243031',
      '14330322',
      '10022423',
      '41324043',
      '41322112',
      '03422421',
      '22414023',
      '01114304',
      '12133201',
      '01330031',
      '43001042',
      '43302044',
      '03241220',
      '44424300',
      '01341211',
      '420',
      '12',
      NULL,
      NULL,
      '4440323',
      2.764950,
      1,
      NULL,
      NULL,
      '321021',
      NULL,
      ' 4-25-1991',
      ' 2-14-2001',
      102.319148,
      NULL,
      NULL,
      8.278127,
      37,
      NULL,
      NULL,
      17.825685,
      26.207988,
      9.857498,
      NULL,
      13.016096,
      NULL,
      NULL,
      NULL,
      3.715563,
      3,
      4,
      30,
      19.136208,
      48.449301,
      7,
      52.990688,
      22.740510,
      2,
      86,
      NULL,
      74,
      51,
      127,
      153.149322,
      ' 7-27-1976',
      14.085801,
      6,
      NULL,
      28.248482,
      11,
      160,
      ' 9-29-1986',
      1,
      1,
      0,
      0.080589,
      1.775802,
      1,
      2,
      0,
      0.376914,
      1.502301,
      0,
      1,
      0,
      1.695609,
      1,
      1,
      NULL,
      1,
      1.285696,
      1.348829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86.822302,
      18,
      1,
      13.277152,
      10.390976,
      1.098192,
      ' 4-23-1990',
      1,
      0.873889,
      81,
      0,
      0,
      59,
      NULL,
      0,
      48.010887,
      1.707547,
      1.156403,
      179.809294,
      ' 4-15-1982',
      1.911332,
      32,
      77,
      20,
      75.981117,
      61.390525,
      21.932639,
      42,
      72.396331,
      69,
      NULL,
      27,
      '11- 8-1984',
      23,
      7.854123,
      14.999640,
      NULL,
      75,
      21.059135,
      1,
      ' 7-28-1992',
      34.968097,
      NULL,
      '10-22-1983',
      12,
      7.183016,
      11.255837,
      18.353070,
      NULL,
      13,
      1.157610,
      8,
      3.087957,
      12,
      3.869450,
      NULL,
      20.160396,
      NULL,
      NULL,
      NULL,
      0,
      1.581208,
      NULL,
      2,
      1,
      5.594308,
      ' 4-10-1975',
      176,
      2,
      ' 9-25-1997',
      NULL,
      2,
      ' 2-16-1975',
      20,
      ' 6-27-2000',
      NULL,
      NULL,
      14,
      6.326390,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      ' 5- 2-1986',
      4,
      2.326824,
      NULL,
      0,
      3,
      13.674022,
      ' 4- 1-1991',
      11.099915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10);
commit;
end;
/


