set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9223065';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20133111',
      '21222404',
      '21432143',
      '42240213',
      '34143240',
      '43002210',
      '13142223',
      '43002231',
      '22340112',
      NULL,
      '31233333',
      '44130124',
      '02113101',
      NULL,
      NULL,
      '33140011',
      '01113013',
      NULL,
      '04410232',
      '40001334',
      '10023130',
      '13114313',
      '01002312',
      '14241334',
      NULL,
      '02343003',
      '40342132',
      '10134322',
      '13311211',
      NULL,
      '40021232',
      '24212020',
      '33213230',
      '31324214',
      '30430241',
      '31304003',
      '20330402',
      NULL,
      '12002112',
      '22103410',
      '03102032',
      NULL,
      '02211020',
      '33014442',
      '441',
      NULL,
      NULL,
      NULL,
      '1120324',
      2,
      NULL,
      1,
      NULL,
      NULL,
      5.936867,
      '11-27-1982',
      ' 9-21-1980',
      15,
      NULL,
      0.129456,
      NULL,
      0,
      14.302613,
      NULL,
      7,
      20,
      15,
      10,
      16,
      2,
      5,
      1,
      NULL,
      NULL,
      12,
      9,
      6,
      5,
      18,
      NULL,
      9.223152,
      NULL,
      NULL,
      115,
      NULL,
      169,
      4,
      120.199141,
      NULL,
      0,
      23,
      NULL,
      17,
      NULL,
      81,
      NULL,
      1,
      3,
      NULL,
      1,
      1,
      1.955032,
      NULL,
      1,
      1.213809,
      0,
      NULL,
      1.714431,
      0.688643,
      0,
      1.031217,
      1.486268,
      0.383171,
      0,
      1,
      0.209069,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 7-1979',
      28,
      2.311708,
      2,
      23.087901,
      27.306812,
      2,
      NULL,
      0.744681,
      1,
      161,
      0.708154,
      1,
      56,
      0,
      NULL,
      63.324215,
      1,
      1,
      116.388285,
      ' 6-14-1997',
      56,
      117.221099,
      96,
      NULL,
      NULL,
      55,
      73.899445,
      7,
      64.774758,
      20,
      NULL,
      77,
      NULL,
      28.939518,
      13,
      20,
      50,
      56.322963,
      113.313896,
      NULL,
      ' 0-29-1979',
      NULL,
      10,
      NULL,
      NULL,
      3.968120,
      NULL,
      NULL,
      NULL,
      4.556358,
      1.971400,
      NULL,
      1.522205,
      NULL,
      5.821932,
      0,
      4.844556,
      26.573855,
      0.225240,
      0,
      0,
      1,
      ' 7-22-1995',
      NULL,
      1.884938,
      NULL,
      ' 9- 1-1975',
      125.323608,
      24,
      ' 5-17-1979',
      NULL,
      NULL,
      NULL,
      24.080936,
      ' 1-25-1990',
      30,
      '10-13-1974',
      5,
      13,
      NULL,
      21.117343,
      NULL,
      '11- 6-1979',
      NULL,
      NULL,
      '10- 9-1975',
      3.758965,
      4,
      ' 9- 6-1982',
      1,
      NULL,
      4.463633,
      ' 9- 9-1987',
      49.327894,
      4,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


