set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9807556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '3',
      '3',
      '0',
      '3',
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '3',
      '2',
      '4',
      '1',
      '1',
      NULL,
      '2',
      '3',
      '3',
      '0',
      '4',
      NULL,
      '4',
      NULL,
      NULL,
      '',
      NULL,
      '1',
      '4',
      NULL,
      '3',
      '',
      '',
      '4',
      '4',
      '3',
      '4',
      '1',
      NULL,
      '0',
      '3',
      '3',
      '3',
      NULL,
      '122',
      NULL,
      30,
      10.632408,
      '0142334',
      0.466723,
      1.355207,
      3,
      NULL,
      '343021',
      NULL,
      ' 3-14-1980',
      ' 0- 3-1994',
      NULL,
      46,
      20,
      17,
      19,
      14.983486,
      55,
      17,
      4,
      NULL,
      NULL,
      NULL,
      40.296673,
      10,
      15.436489,
      9,
      21.307466,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      25.787233,
      28,
      1,
      100,
      NULL,
      110.714452,
      217.725084,
      75,
      82.662388,
      ' 3- 1-2000',
      66.086909,
      7,
      15,
      5.662603,
      197,
      19.900203,
      ' 1- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      104,
      6,
      7,
      NULL,
      11,
      6,
      ' 3-12-1986',
      0.164723,
      0.379587,
      97.868189,
      0,
      NULL,
      110,
      3.026911,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-25-1989',
      27,
      NULL,
      112,
      NULL,
      88,
      23,
      85.175147,
      33.088948,
      90,
      6.811613,
      31.014787,
      27,
      ' 5-11-1975',
      25,
      34.524118,
      13.522091,
      41,
      NULL,
      129.601306,
      4.359647,
      ' 2-12-1998',
      4.274137,
      10.062076,
      ' 7-14-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      241,
      0,
      ' 8- 7-2002',
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      3,
      ' 9-15-1999',
      0.526422,
      16.930802,
      ' 7-18-1990',
      116,
      115.223621,
      '10-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      22.699264,
      ' 5-28-1995',
      NULL,
      14,
      NULL,
      ' 3-24-1998',
      0,
      NULL,
      ' 6- 2-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


