set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8226743';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '41043422',
      NULL,
      '43312244',
      '00403100',
      '03043002',
      '42034011',
      '03401214',
      NULL,
      '22224131',
      '20022144',
      '02120311',
      '44101003',
      '32021432',
      '03233411',
      '02001142',
      NULL,
      '32142102',
      NULL,
      '12204443',
      NULL,
      NULL,
      '44144301',
      NULL,
      '10132022',
      '01240423',
      NULL,
      '22423424',
      '41210100',
      '40444004',
      '22310444',
      NULL,
      '41124032',
      '42001304',
      '42024312',
      '14113003',
      NULL,
      '02330011',
      '23203430',
      '43442220',
      NULL,
      '01322323',
      '31112400',
      '03212020',
      NULL,
      '',
      NULL,
      NULL,
      '1421422',
      0,
      NULL,
      0,
      NULL,
      '222302',
      3,
      ' 1- 5-1975',
      ' 7- 3-2003',
      11,
      NULL,
      22.803333,
      12,
      22,
      0,
      81,
      13,
      29,
      23,
      0.204195,
      NULL,
      18,
      3.789502,
      19,
      8.454793,
      NULL,
      13.860367,
      14.569354,
      3.905231,
      5.630289,
      2,
      57.470860,
      3,
      NULL,
      52,
      NULL,
      NULL,
      NULL,
      70.252034,
      120.190348,
      NULL,
      40,
      13.440501,
      36.297359,
      14,
      4.547856,
      248.146555,
      ' 7- 8-2003',
      3,
      NULL,
      0,
      3.132244,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.716617,
      0,
      1,
      1.991279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-20-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-1978',
      63,
      10,
      NULL,
      44,
      14.651014,
      10,
      3,
      3.340309,
      20,
      25.862578,
      13,
      NULL,
      ' 8- 2-1989',
      9.954976,
      28.415652,
      38,
      82,
      69,
      5,
      NULL,
      ' 3-26-1999',
      5.681027,
      5.859427,
      ' 0-11-1994',
      NULL,
      17.827378,
      9.242803,
      11.191660,
      NULL,
      6.350420,
      NULL,
      15.443527,
      NULL,
      50.228886,
      0.742749,
      5,
      6.146444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.795695,
      12.225081,
      NULL,
      ' 1-29-1987',
      1,
      16.329048,
      '11-14-1987',
      11.803162,
      59.983360,
      21.368615,
      41,
      '10-14-2001',
      42,
      1,
      146,
      ' 0- 9-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      123,
      NULL,
      NULL,
      102,
      38.096270,
      27,
      14,
      6.141984,
      4.428717,
      NULL,
      0,
      0.213527,
      15.779932,
      NULL,
      3.582857,
      16,
      1,
      1.223776,
      61,
      NULL,
      3.581342,
      136.259354,
      NULL,
      13,
      NULL,
      1,
      NULL,
      0.842036,
      0.597305,
      0.159662,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      10.197464,
      0.544518,
      2.837302,
      2.418226,
      35.480392,
      NULL,
      NULL,
      4.107896,
      NULL,
      0.474926,
      1,
      NULL,
      16.417110,
      0,
      8,
      NULL,
      NULL,
      0,
      NULL,
      14,
      NULL,
      0.583291,
      7.005757,
      0,
      1.203013,
      NULL,
      2.888572,
      NULL,
      '11- 8-1998',
      ' 2-18-2000',
      ' 3-27-1980',
      NULL,
      ' 7-13-1995',
      ' 9-27-1986',
      ' 7- 1-1992',
      NULL);
commit;
end;
/


