set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1111',
      '03230133',
      '24221110',
      '21411431',
      '24430114',
      NULL,
      NULL,
      NULL,
      '12131331',
      '30141141',
      '33130023',
      '43140103',
      NULL,
      '10311340',
      NULL,
      '32122304',
      '41001234',
      '02300014',
      '30034312',
      '32444031',
      NULL,
      '40114241',
      NULL,
      '33441411',
      '31334442',
      '14203113',
      NULL,
      '03442223',
      '10312434',
      NULL,
      '20202321',
      '31032313',
      '34301203',
      '40312421',
      '01441404',
      '23421421',
      '02421413',
      NULL,
      '03240414',
      '31020204',
      '03402040',
      '00100142',
      '02420312',
      '41311114',
      '32340104',
      NULL,
      '',
      NULL,
      NULL,
      '4430041',
      1.101293,
      1.923144,
      0,
      NULL,
      '342411',
      2,
      ' 7- 5-1993',
      ' 7-22-1976',
      NULL,
      NULL,
      32,
      13,
      15.606198,
      7.754622,
      33,
      NULL,
      NULL,
      16.737571,
      12.526940,
      NULL,
      NULL,
      3.020565,
      21.360801,
      2.767722,
      2.321077,
      NULL,
      52,
      10,
      NULL,
      8,
      77.791084,
      11.254141,
      NULL,
      23.954611,
      181,
      52,
      NULL,
      NULL,
      91.757720,
      ' 7-29-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022694,
      0.080510,
      NULL,
      1.592563,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 8-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-11-1975',
      2.775625,
      7,
      89,
      70.748274,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      36.380537,
      27.474043,
      10.185367,
      NULL,
      16.972592,
      13,
      17.276139,
      NULL,
      1,
      NULL,
      9,
      ' 0-16-1980',
      23,
      12.176628,
      ' 6-15-1985',
      5.112941,
      11,
      11,
      5,
      13.896258,
      3,
      NULL,
      16,
      NULL,
      45,
      1.751650,
      NULL,
      8.885863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 6-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      0,
      NULL,
      1,
      9,
      ' 5-25-1988',
      0,
      NULL,
      9,
      11.725219,
      ' 5-17-1998',
      14,
      0,
      91,
      ' 8-26-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      45.403578,
      2.881779,
      90.995337,
      NULL,
      86.770227,
      46.767254,
      10.192703,
      46.194862,
      17.528464,
      4,
      92,
      1.451440,
      1,
      26.358810,
      NULL,
      3,
      77.832965,
      1,
      3,
      53.417270,
      0.900296,
      0,
      NULL,
      0.288231,
      NULL,
      19.388656,
      NULL,
      57.434934,
      NULL,
      0.279026,
      1.216969,
      NULL,
      1,
      0,
      94.170470,
      76,
      14.119677,
      NULL,
      NULL,
      96,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      0,
      0,
      81,
      13,
      10,
      29,
      69,
      84,
      NULL,
      NULL,
      NULL,
      NULL,
      3.229935,
      4.725332,
      3,
      0.609825,
      NULL,
      1.423623,
      26.413458,
      ' 9-20-1991',
      NULL,
      NULL,
      NULL,
      ' 8-11-2001',
      NULL,
      ' 2-10-1985',
      NULL);
commit;
end;
/


