set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0442',
      '10010130',
      '13033310',
      NULL,
      '33311134',
      '21203412',
      NULL,
      NULL,
      '30041203',
      '40412433',
      '40302002',
      '00244102',
      '13323403',
      '02003431',
      NULL,
      NULL,
      '40133323',
      NULL,
      '21022104',
      '02222410',
      '14134010',
      '22144404',
      '33143332',
      '10143341',
      '44342330',
      NULL,
      '30233141',
      '04423344',
      '03223113',
      NULL,
      '44040243',
      NULL,
      '42434143',
      '44242322',
      '23300113',
      '20432413',
      '11001222',
      '10224244',
      '10200002',
      '14431132',
      '02011114',
      '31301131',
      '13304102',
      '32422301',
      '24330241',
      '440',
      '23',
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      '232413',
      1.032360,
      ' 0- 6-1991',
      ' 0-15-1978',
      37.094179,
      NULL,
      NULL,
      NULL,
      7.870369,
      NULL,
      58,
      NULL,
      4.003093,
      24,
      25,
      16.343388,
      28,
      5,
      0,
      10,
      6,
      7,
      24.400930,
      11,
      8.503629,
      18,
      28.224557,
      1,
      NULL,
      27.524381,
      157,
      74,
      150,
      NULL,
      127,
      ' 8-10-1980',
      25,
      7.242551,
      27,
      13,
      NULL,
      NULL,
      ' 5-25-1995',
      1.211969,
      NULL,
      5.611651,
      3,
      2.867491,
      7.698592,
      5,
      NULL,
      NULL,
      0.394834,
      11,
      0,
      0.081083,
      0.111864,
      0.828263,
      NULL,
      NULL,
      1,
      1,
      0.012071,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 8-1994',
      27,
      NULL,
      12,
      7.108277,
      2,
      0,
      NULL,
      NULL,
      1.341663,
      96,
      0,
      1.967807,
      25,
      0.699373,
      NULL,
      37.727444,
      1,
      0,
      99.958769,
      NULL,
      5.133991,
      21,
      83,
      26,
      50.266417,
      94.987605,
      43,
      85.766247,
      44,
      61.762807,
      9,
      NULL,
      ' 2-17-1994',
      12.168050,
      9.619811,
      8.671879,
      19.004088,
      74,
      110,
      7,
      ' 3- 4-1992',
      11.655566,
      4.003902,
      ' 2- 8-1995',
      3.290200,
      6,
      NULL,
      6.332864,
      3,
      NULL,
      3,
      9,
      1,
      19,
      0.637707,
      3,
      NULL,
      2.716091,
      NULL,
      NULL,
      0.354905,
      1,
      NULL,
      NULL,
      2,
      5,
      ' 8- 4-1987',
      NULL,
      0.087550,
      ' 5-20-1977',
      NULL,
      NULL,
      NULL,
      0,
      ' 2-21-1994',
      42.376088,
      ' 0- 5-1996',
      10.717081,
      5.536901,
      ' 8-16-2003',
      32.841377,
      26.156404,
      ' 8-23-1978',
      2.596172,
      NULL,
      '11-15-1980',
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      ' 8-16-1976',
      61.057220,
      18.168447,
      1.063113,
      '10-24-1992',
      3.473540,
      27,
      NULL,
      6,
      1.949712,
      NULL,
      55,
      ' 1-25-1983',
      12,
      0,
      137.028769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


