set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40210220',
      '02343240',
      '33141144',
      '33001043',
      '03431223',
      '40421331',
      NULL,
      NULL,
      '42140232',
      '04113020',
      '14443103',
      '43144133',
      '23221101',
      '10001012',
      '10140332',
      '30310023',
      '42240141',
      NULL,
      NULL,
      '00044130',
      '43123311',
      '13032311',
      '10420342',
      '04124333',
      NULL,
      '34022013',
      '22412012',
      '33302232',
      NULL,
      NULL,
      '04302344',
      '34214122',
      NULL,
      '34141444',
      '44441023',
      NULL,
      '03312022',
      NULL,
      '31044114',
      '41023241',
      '03233131',
      '23124044',
      NULL,
      '20131441',
      '140',
      '04',
      21.535003,
      9.577551,
      NULL,
      3,
      58.779762,
      0,
      NULL,
      '002344',
      1.342510,
      ' 7-24-1976',
      ' 8-27-1988',
      57.540171,
      NULL,
      16,
      NULL,
      14.724937,
      5.848722,
      56,
      19.380158,
      19.907636,
      NULL,
      12,
      3.931893,
      9.529984,
      4.956767,
      0,
      6.798292,
      NULL,
      10,
      3,
      18.009148,
      29.658277,
      15,
      36,
      2,
      0,
      72.469792,
      85.298463,
      16.993678,
      176.331508,
      129.572164,
      86.532630,
      '10-20-1981',
      24,
      8,
      25,
      25,
      0,
      78,
      ' 1-25-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      5.052016,
      7,
      4.223532,
      4,
      ' 0- 2-1980',
      0,
      NULL,
      204,
      0,
      0,
      141,
      NULL,
      0.595975,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 0-1985',
      56,
      57,
      20,
      61,
      37,
      6.844090,
      62,
      0,
      28.890694,
      37,
      NULL,
      13.007493,
      ' 0- 3-2000',
      11,
      4,
      13,
      2,
      37,
      23.937482,
      3,
      ' 4- 3-1998',
      NULL,
      13,
      '10-22-1986',
      2.960219,
      0.268774,
      NULL,
      13.374316,
      1.201095,
      6,
      3,
      11,
      NULL,
      NULL,
      NULL,
      3,
      6.003823,
      29.389905,
      3,
      NULL,
      1.706398,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      145.556547,
      9.841848,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      ' 5-25-2002',
      NULL,
      ' 1-10-1977',
      4.429894,
      NULL,
      '10-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      36.287598,
      6,
      26,
      ' 8-25-1984',
      1.217337,
      NULL,
      NULL,
      4,
      1.852560,
      0.090132,
      80.851377,
      ' 9-27-1992',
      NULL,
      NULL,
      48.328777,
      '10-25-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


