set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '4',
      '2',
      NULL,
      '1',
      '2',
      '3',
      '2',
      NULL,
      '1',
      '3',
      '2',
      NULL,
      '2',
      NULL,
      '1',
      '4',
      '1',
      NULL,
      NULL,
      '4',
      '3',
      '2',
      '',
      '1',
      NULL,
      '2',
      '1',
      '3',
      '4',
      '2',
      '',
      '',
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      '4',
      '0',
      '0',
      '243',
      '30343114',
      0,
      NULL,
      '3210030',
      1.061353,
      66,
      0,
      NULL,
      '203412',
      1.277005,
      ' 5- 9-2002',
      ' 0-11-1986',
      106.678686,
      NULL,
      0.392400,
      12.845454,
      0.500566,
      NULL,
      86,
      6.905565,
      9,
      4,
      8,
      7.444409,
      NULL,
      10.446115,
      31,
      26,
      NULL,
      NULL,
      NULL,
      16.812990,
      NULL,
      NULL,
      64,
      3.912274,
      NULL,
      85,
      22,
      13.454918,
      55.527900,
      1.723737,
      NULL,
      NULL,
      36.907695,
      36,
      6,
      22.972540,
      145.563349,
      6.455246,
      ' 9- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.601191,
      NULL,
      4,
      1.476780,
      5,
      1,
      NULL,
      1.299999,
      0,
      189.607016,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      ' 2-14-1992',
      8.871877,
      50.267764,
      2.934516,
      39.964759,
      41.880272,
      17.121927,
      16.240445,
      6,
      24,
      NULL,
      45.040063,
      43.878336,
      ' 2- 5-1996',
      15.142895,
      32,
      12.089579,
      53,
      38.185394,
      NULL,
      0,
      ' 4- 6-1994',
      3,
      8.707641,
      ' 4-24-2000',
      NULL,
      17.933838,
      14.714605,
      12,
      11.847068,
      3,
      1.214618,
      5,
      1.869478,
      26,
      1,
      NULL,
      9,
      10.568698,
      0.823664,
      2.801058,
      0.029633,
      0.585893,
      ' 7-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      82,
      NULL,
      '10-15-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-1974',
      13,
      ' 4-17-2003',
      6.917120,
      9.206955,
      ' 3-16-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      ' 4- 6-1980',
      51,
      22,
      11,
      ' 3-24-1979',
      3,
      181.458226,
      NULL,
      NULL,
      20.074163,
      12.911062,
      79.769553,
      ' 2-14-1991',
      NULL,
      0.514582,
      151,
      '10- 1-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


