set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8703287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '2',
      '2',
      '4',
      '1',
      NULL,
      '1',
      '4',
      '4',
      '0',
      '1',
      '4',
      '4',
      '4',
      '3',
      NULL,
      '0',
      '3',
      '4',
      '2',
      NULL,
      '4',
      '2',
      '',
      NULL,
      '',
      '0',
      '2',
      '3',
      NULL,
      '3',
      '',
      '',
      NULL,
      NULL,
      '1',
      '4',
      '1',
      '1',
      '1',
      NULL,
      '1',
      '3',
      '3',
      '012',
      '23323310',
      7.748971,
      41,
      '0344404',
      NULL,
      184.155271,
      0,
      0,
      '144134',
      5,
      ' 4- 4-1993',
      ' 5-20-1982',
      238.206460,
      95.455318,
      22,
      NULL,
      6.641346,
      4.842789,
      NULL,
      NULL,
      NULL,
      NULL,
      19.462608,
      NULL,
      12.018237,
      0,
      31,
      5,
      1.873649,
      3.136701,
      9.237683,
      NULL,
      24,
      1,
      7.639400,
      11,
      0,
      87.121859,
      17,
      56.477994,
      89.138003,
      58,
      162,
      '11-26-1995',
      7,
      8.936737,
      14,
      15.167761,
      51,
      153.665069,
      ' 4- 4-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.396641,
      14.157745,
      2,
      NULL,
      9.349927,
      7,
      ' 0-16-1978',
      NULL,
      1.425228,
      155,
      1,
      1.594091,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-29-1994',
      44.034592,
      NULL,
      50.628567,
      42.237686,
      55,
      17,
      36,
      NULL,
      NULL,
      27,
      18.478735,
      40.673902,
      NULL,
      NULL,
      14.149324,
      7.865557,
      29.465705,
      44.011778,
      78,
      2.988191,
      '11-14-1977',
      NULL,
      5,
      ' 1-22-1995',
      1,
      17.855600,
      NULL,
      1,
      13.412853,
      1.473543,
      1.710899,
      14,
      1,
      49,
      3,
      12.979907,
      8.196480,
      5.066828,
      3.654921,
      3.379428,
      1,
      NULL,
      ' 2-13-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9,
      ' 0-12-1977',
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      32,
      ' 8- 4-1998',
      5,
      10,
      '10-14-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.824566,
      ' 4-15-1981',
      NULL,
      NULL,
      30,
      ' 4-26-1977',
      1,
      146.361874,
      '10-27-1995',
      4,
      NULL,
      15,
      28,
      ' 0-29-1997',
      NULL,
      0,
      163.515333,
      ' 7- 6-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


