set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0444',
      NULL,
      '22043001',
      '32442032',
      '33111202',
      NULL,
      '12321040',
      '23200004',
      '42210401',
      '20002401',
      NULL,
      '32312202',
      '02301143',
      NULL,
      '34400220',
      '02322411',
      '01101330',
      '43340310',
      '23343332',
      NULL,
      NULL,
      NULL,
      '30420223',
      NULL,
      '01103014',
      '44002102',
      '22410403',
      NULL,
      '41410022',
      NULL,
      '04412423',
      '43234021',
      '30142443',
      '32234133',
      '32304241',
      NULL,
      '24214421',
      '20420000',
      NULL,
      '14101422',
      NULL,
      '04332340',
      NULL,
      '23413332',
      '30433043',
      '',
      '',
      NULL,
      NULL,
      '2132211',
      2.015260,
      0.546819,
      0,
      NULL,
      '140113',
      0,
      '11-28-1994',
      ' 0- 7-2001',
      NULL,
      NULL,
      36.863502,
      10.856374,
      NULL,
      4.671231,
      NULL,
      19.463237,
      19,
      1,
      NULL,
      15,
      3.835004,
      13,
      NULL,
      12.039816,
      7.656909,
      11,
      11.060036,
      8.218215,
      16.225782,
      6.709930,
      63.028323,
      9,
      NULL,
      4.368373,
      75.996006,
      59,
      82.781004,
      NULL,
      NULL,
      ' 3-11-1991',
      6.984706,
      NULL,
      3,
      NULL,
      109,
      107.333343,
      ' 6- 2-1982',
      7.998951,
      5,
      NULL,
      1.553298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      0,
      0.315954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-12-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 1-1989',
      97,
      78.652684,
      93,
      142.516218,
      89.795480,
      NULL,
      131,
      150.891392,
      137.348572,
      NULL,
      52.148944,
      7,
      NULL,
      4,
      21,
      7,
      6.224042,
      NULL,
      12,
      2.498485,
      ' 7-13-1998',
      4.683157,
      1.453336,
      NULL,
      6.482936,
      5,
      2.415159,
      11.537266,
      NULL,
      0.346415,
      NULL,
      10,
      NULL,
      7,
      4.877016,
      0,
      0.793872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 3-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.328454,
      10,
      12.997466,
      ' 2-19-1989',
      0,
      22.273900,
      ' 6-12-2001',
      0.246728,
      1.974605,
      NULL,
      46.917904,
      NULL,
      23,
      1,
      232.174963,
      NULL,
      NULL,
      NULL,
      NULL,
      74,
      NULL,
      0.327262,
      NULL,
      68.339667,
      41.893924,
      34.156235,
      NULL,
      45,
      5,
      7.059274,
      37.898363,
      1,
      1.922576,
      NULL,
      1,
      0.639934,
      NULL,
      1,
      1.717857,
      22,
      3,
      6.615610,
      249,
      58.653349,
      2,
      NULL,
      1,
      NULL,
      0.826503,
      0.013498,
      0.048340,
      2,
      0.800800,
      0.724280,
      70.869304,
      57.795675,
      41.987148,
      13.571966,
      25.880702,
      38.648316,
      1,
      NULL,
      11,
      1,
      8,
      6,
      10,
      3,
      65.154575,
      NULL,
      19,
      1,
      NULL,
      1,
      NULL,
      1,
      35.808910,
      NULL,
      29.547982,
      10,
      41,
      9.457345,
      17,
      4,
      5.341944,
      4,
      1.960536,
      NULL,
      1.495471,
      50,
      ' 5-25-1979',
      ' 1-24-1980',
      '11-23-1979',
      ' 0-27-1997',
      ' 9-27-1982',
      ' 9- 4-1986',
      ' 1-26-1985',
      NULL);
commit;
end;
/


