set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9116131';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4334',
      '22301021',
      NULL,
      '13302224',
      '31044000',
      '13444242',
      '30131343',
      NULL,
      NULL,
      '04012314',
      '21110224',
      '41032310',
      '44411332',
      '30440312',
      '24113400',
      '30123443',
      '20112300',
      '40131244',
      NULL,
      '22122011',
      '22220424',
      '03102243',
      '33120133',
      NULL,
      '13411232',
      '34142200',
      '22144230',
      '43414023',
      '41400403',
      '23104200',
      '42123102',
      '42124210',
      '14021431',
      '33033341',
      '03141112',
      '21112314',
      '41311000',
      '41030233',
      '30131304',
      '14303013',
      '32100324',
      '14110334',
      '10213013',
      '20444304',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.619639,
      NULL,
      NULL,
      '031334',
      NULL,
      '10- 0-1989',
      ' 7-28-1996',
      19.355459,
      NULL,
      NULL,
      17.135499,
      19.451585,
      9,
      NULL,
      2,
      NULL,
      17.947861,
      12.529401,
      28,
      18,
      NULL,
      20.603425,
      6.258954,
      8.101984,
      15,
      85.267511,
      1.326439,
      36.166175,
      27.841135,
      21.182827,
      18,
      1.160768,
      1,
      193.137127,
      87.364608,
      27.492475,
      13.365753,
      83,
      ' 0- 6-1997',
      NULL,
      55,
      17,
      19,
      NULL,
      183,
      NULL,
      0.435359,
      0.938961,
      NULL,
      2.118218,
      0.660478,
      0,
      1,
      1,
      NULL,
      2.371699,
      NULL,
      0,
      0.038194,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-11-2000',
      104,
      12.002023,
      6.970204,
      3.353747,
      6.284816,
      10.523027,
      '11-19-1998',
      0,
      NULL,
      NULL,
      1.656848,
      4.783402,
      18.527059,
      0.252657,
      2.624781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      56,
      91.291744,
      43.660074,
      32.463784,
      102,
      5.753869,
      98.713358,
      71.142796,
      NULL,
      43,
      ' 6-23-2003',
      NULL,
      22,
      NULL,
      64.447914,
      92.657428,
      119.866469,
      9,
      ' 5-15-1995',
      28.074655,
      31.212675,
      ' 3- 2-1975',
      14,
      NULL,
      7,
      0.857729,
      10,
      NULL,
      1.933539,
      10.783708,
      0.764260,
      116.442272,
      0,
      7,
      7.442431,
      7.069940,
      3.765876,
      2,
      3.914365,
      0.952592,
      ' 3- 7-1995',
      7,
      0.673013,
      0,
      '10-24-1984',
      77,
      3.822806,
      '11-26-1983',
      14.716045,
      3.449927,
      ' 0- 5-1997',
      39.169859,
      '11-21-2002',
      15.868152,
      ' 8-17-2001',
      NULL,
      13.451552,
      ' 0-22-1974',
      NULL,
      82.772114,
      NULL,
      NULL,
      5,
      '10-14-1984',
      NULL,
      NULL,
      NULL,
      3,
      0,
      18.684523,
      '11-19-1976',
      NULL,
      NULL,
      NULL,
      '11- 7-2003',
      1,
      32.631336,
      ' 4-13-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.828642);
commit;
end;
/


