set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015635';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0134',
      '42300434',
      '20403140',
      '01002441',
      NULL,
      '43114240',
      '20023223',
      NULL,
      '03240204',
      '12231243',
      '20133413',
      '14433001',
      '04324440',
      '44321232',
      '21141421',
      '31112431',
      '24244302',
      NULL,
      '10102420',
      '03123303',
      '42141324',
      '02024101',
      NULL,
      '40301411',
      '00422441',
      '00324412',
      '30441430',
      '41201004',
      '22404244',
      '11341213',
      NULL,
      '23103212',
      NULL,
      '21401311',
      '13042321',
      '41210110',
      '13441003',
      NULL,
      '01203134',
      '43322304',
      NULL,
      '24214102',
      '02444143',
      '23011110',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '4001412',
      NULL,
      1.133214,
      1,
      NULL,
      '001023',
      NULL,
      ' 1-24-1982',
      ' 0-13-1994',
      52.175660,
      NULL,
      9,
      NULL,
      21,
      0.350528,
      5,
      1.712613,
      NULL,
      7.204658,
      0,
      6.095546,
      14,
      3.650006,
      4.686807,
      NULL,
      0.814843,
      9,
      12.528630,
      12,
      NULL,
      1.343360,
      NULL,
      12,
      NULL,
      10,
      127,
      15,
      6,
      NULL,
      107,
      '11- 8-1974',
      43,
      NULL,
      18,
      3,
      6,
      78,
      ' 5-29-1999',
      0,
      3,
      NULL,
      0.901177,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.121156,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-26-1989',
      24.797528,
      25.920527,
      NULL,
      83.539521,
      27.654462,
      81.592790,
      NULL,
      90.509526,
      NULL,
      NULL,
      78.502775,
      28,
      ' 9- 6-1982',
      NULL,
      12.974124,
      NULL,
      32,
      18.953867,
      10,
      0.949840,
      ' 2-11-1980',
      NULL,
      7.841041,
      ' 8-18-1995',
      7,
      NULL,
      8.239950,
      6,
      10.821124,
      3,
      NULL,
      5,
      NULL,
      46,
      1,
      12,
      10.799565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-14-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.645869,
      ' 7-27-1982',
      0,
      35.883643,
      NULL,
      10,
      23.603656,
      11,
      NULL,
      ' 5-12-1994',
      NULL,
      0.329201,
      124.042675,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      1,
      41.989176,
      37,
      NULL,
      6.966343,
      43,
      50.853539,
      56.656476,
      NULL,
      21.012311,
      1,
      1,
      53.950570,
      NULL,
      NULL,
      NULL,
      0.821563,
      NULL,
      14,
      0.373302,
      4.089445,
      0.795435,
      13,
      1,
      NULL,
      1,
      39.276943,
      1.616531,
      1,
      3.325501,
      1,
      0,
      NULL,
      21,
      17,
      NULL,
      6.921027,
      14.039629,
      25,
      0.140327,
      11,
      NULL,
      0.890649,
      NULL,
      12.955276,
      9,
      7,
      25,
      0,
      31.691986,
      NULL,
      1.439222,
      5.556689,
      17,
      5.833865,
      20.796207,
      2,
      25,
      18.562596,
      29,
      2,
      8.866844,
      NULL,
      NULL,
      1.073825,
      1,
      1,
      NULL,
      28.030229,
      ' 2- 8-2000',
      NULL,
      ' 8-25-1994',
      ' 1- 6-1994',
      ' 8-19-1980',
      NULL,
      ' 9-25-1992',
      NULL);
commit;
end;
/


