set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329209';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3110',
      '21430142',
      '00003412',
      '31444240',
      '31101210',
      '02430034',
      '01430343',
      '20201213',
      '01031003',
      '02222042',
      NULL,
      '33442310',
      '14001224',
      '12043234',
      '30142401',
      '14112144',
      '24133413',
      '21020422',
      '14331313',
      '01012201',
      '43424403',
      '34002142',
      '02331223',
      '10414430',
      '24204303',
      '40332102',
      '23401100',
      '44314234',
      '22104322',
      '14434430',
      NULL,
      '01144231',
      NULL,
      '24310333',
      '42241401',
      '11432440',
      '30000441',
      '12414203',
      '31411332',
      NULL,
      '42333122',
      '42411340',
      '21112342',
      NULL,
      '33332334',
      '221',
      '11',
      NULL,
      NULL,
      '1301134',
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.857729,
      ' 5-16-1979',
      ' 2-23-1975',
      25,
      NULL,
      9.148902,
      6.587002,
      10.476188,
      3.860933,
      34,
      NULL,
      NULL,
      NULL,
      53,
      NULL,
      5.559348,
      NULL,
      12.711665,
      NULL,
      3,
      NULL,
      NULL,
      8.792396,
      7.020888,
      3,
      19.847059,
      2,
      0,
      NULL,
      13.491113,
      20,
      17,
      63,
      173.206963,
      '11-24-2000',
      24,
      NULL,
      15.189574,
      4,
      NULL,
      110.985125,
      ' 3-29-1992',
      0.044864,
      1,
      0.302134,
      0.823589,
      2,
      0,
      5.578325,
      0,
      NULL,
      1.582328,
      0,
      1.311407,
      1,
      0.794721,
      NULL,
      0.962976,
      0,
      0.275859,
      NULL,
      0.817826,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-23-1995',
      NULL,
      41.593747,
      16,
      23,
      NULL,
      1,
      '11-28-1974',
      0,
      7,
      81,
      NULL,
      1.236506,
      0,
      NULL,
      3,
      57,
      NULL,
      NULL,
      NULL,
      ' 7-15-2002',
      44,
      10.707070,
      53,
      29,
      8.944581,
      48,
      69,
      78.393729,
      60.610939,
      28.401123,
      65.799503,
      NULL,
      ' 9-20-1999',
      19.614648,
      9.554508,
      5,
      NULL,
      12.246115,
      58,
      5,
      ' 5-10-1982',
      18,
      NULL,
      ' 2-10-1992',
      NULL,
      2.418413,
      NULL,
      0,
      9,
      4,
      0.724625,
      5.256415,
      1.039118,
      NULL,
      NULL,
      NULL,
      3.742867,
      9.038182,
      2.706689,
      0,
      5.370012,
      NULL,
      ' 2- 1-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 4-1991',
      30,
      ' 8-21-1987',
      12,
      10.758203,
      NULL,
      17,
      0.171086,
      ' 4-18-1997',
      13.131973,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7.706590,
      NULL,
      42,
      5.242943,
      NULL,
      '10-29-1998',
      NULL,
      36,
      ' 2- 3-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


