set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9940049';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '1',
      '2',
      '2',
      '4',
      '4',
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      '3',
      '2',
      '4',
      '1',
      '0',
      '2',
      '0',
      '2',
      '3',
      NULL,
      '2',
      '',
      NULL,
      '',
      '3',
      NULL,
      NULL,
      '2',
      '3',
      '',
      '',
      '3',
      '3',
      '3',
      '3',
      '2',
      '3',
      '2',
      '1',
      '4',
      '4',
      NULL,
      '100',
      NULL,
      NULL,
      21.490291,
      '1422321',
      3,
      0,
      3,
      NULL,
      NULL,
      1,
      ' 6-18-1983',
      ' 7-21-1995',
      29,
      NULL,
      35,
      23,
      46.425443,
      14.966468,
      66.288560,
      1.729446,
      30.580106,
      10,
      NULL,
      2,
      20,
      1,
      32.564907,
      9.570260,
      29.315670,
      20.309894,
      10,
      10.996314,
      77.281154,
      24.383251,
      71,
      NULL,
      NULL,
      130,
      2,
      13,
      233,
      10.055587,
      NULL,
      ' 5-20-1988',
      39,
      46.318999,
      19,
      33,
      181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      3.930391,
      0.536650,
      6,
      1.065882,
      ' 6-21-1976',
      1,
      0,
      80.896960,
      0.455168,
      NULL,
      137.883345,
      1.163190,
      NULL,
      92,
      NULL,
      NULL,
      NULL,
      ' 5-16-1989',
      95,
      74,
      64,
      19.567467,
      23.784751,
      83.947124,
      NULL,
      NULL,
      46.534678,
      8,
      31.619856,
      NULL,
      ' 1- 9-2001',
      0.595856,
      0,
      NULL,
      38,
      129.645744,
      9,
      14,
      ' 7-20-1982',
      18,
      NULL,
      ' 8-26-1993',
      NULL,
      28,
      0,
      NULL,
      28,
      10,
      0.452517,
      NULL,
      1,
      112.182458,
      3.631874,
      0.500596,
      21,
      NULL,
      NULL,
      0.586349,
      NULL,
      1,
      ' 9- 4-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      286.415545,
      NULL,
      ' 5-22-1976',
      NULL,
      NULL,
      NULL,
      58.469770,
      NULL,
      31.208136,
      ' 2- 0-1988',
      15,
      10.716514,
      '11- 3-1990',
      127,
      NULL,
      ' 9- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      17.372794,
      ' 4-17-1980',
      29.224872,
      32,
      10,
      ' 8-29-1997',
      1,
      0,
      ' 5- 3-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


