set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8233129';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3214',
      '01442300',
      NULL,
      '43031433',
      '10043314',
      NULL,
      '04323424',
      '32011300',
      NULL,
      '04330232',
      '30404121',
      '31400022',
      '31124103',
      '04142334',
      '21243241',
      '04040300',
      '24334022',
      '44021111',
      '20440422',
      '03301224',
      NULL,
      '20321143',
      NULL,
      '14300231',
      '33243421',
      '24214010',
      NULL,
      NULL,
      '23341304',
      '14024131',
      '04243323',
      '42343034',
      '33122322',
      '11444120',
      '04414024',
      '02020213',
      '10022202',
      '04432113',
      '34333100',
      '33324211',
      '44104102',
      NULL,
      '31411110',
      '20004033',
      '23441212',
      '302',
      '24',
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      '303030',
      NULL,
      NULL,
      ' 4-11-1998',
      81,
      NULL,
      11,
      11.795905,
      4,
      18,
      39,
      15.150451,
      11.690121,
      8.148251,
      43.987588,
      14.325817,
      NULL,
      25,
      11.305360,
      10,
      8,
      14,
      48,
      23,
      NULL,
      15.930527,
      26,
      10.803275,
      0,
      120.264532,
      136.723412,
      38,
      NULL,
      61,
      169,
      ' 1-11-1996',
      33.196216,
      NULL,
      NULL,
      NULL,
      101.446821,
      NULL,
      ' 6-28-2002',
      0,
      1.343104,
      1,
      NULL,
      NULL,
      0.089864,
      0.298719,
      1,
      0.144887,
      0.660429,
      NULL,
      1.237832,
      1,
      NULL,
      0,
      0,
      NULL,
      0.560274,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-16-1994',
      0,
      5.918469,
      NULL,
      15.077557,
      16,
      7,
      ' 8-19-1992',
      NULL,
      0,
      69.038210,
      1,
      0.019121,
      60.629284,
      0.607779,
      1,
      14.244073,
      0,
      0.358091,
      165,
      ' 7-28-1992',
      24.697407,
      50.304300,
      37.352729,
      92.052333,
      19,
      NULL,
      34,
      40.560529,
      87,
      38,
      NULL,
      10,
      ' 6- 4-1999',
      30,
      8,
      5.750213,
      NULL,
      NULL,
      28,
      1,
      ' 5-22-1978',
      0,
      1,
      ' 7- 9-2003',
      8.080424,
      8,
      NULL,
      30.486461,
      NULL,
      NULL,
      1.585424,
      18.661191,
      1,
      134.145425,
      NULL,
      0.569096,
      7,
      8,
      1.368119,
      1.019005,
      NULL,
      0.396563,
      '11- 0-1974',
      NULL,
      0,
      2,
      NULL,
      61.606901,
      NULL,
      NULL,
      NULL,
      13.773788,
      ' 4- 6-1978',
      33,
      ' 9- 0-1979',
      8,
      ' 1-25-1978',
      3,
      9.376159,
      ' 0- 7-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      14.296276,
      ' 1-17-1993',
      3.518849,
      1,
      ' 4-23-1978',
      0,
      2,
      NULL,
      '11-19-1995',
      NULL,
      9.613523,
      13,
      ' 1- 4-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


