set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9221924';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2003',
      '32030020',
      NULL,
      '00003001',
      '00311230',
      '24323444',
      '33404020',
      '04400424',
      '20432211',
      '21113412',
      '00402414',
      '13112340',
      '44333022',
      '23010441',
      '04114303',
      '02044012',
      '13414411',
      '32233231',
      '22342124',
      '14300114',
      '40443334',
      '43013421',
      '10123204',
      '24401341',
      NULL,
      '13334210',
      '13243341',
      '43142023',
      '14140203',
      '21221101',
      '03020341',
      '04123313',
      NULL,
      '23212201',
      '13323023',
      NULL,
      '34344414',
      '33242143',
      '14032134',
      '34222224',
      '10243220',
      '32324141',
      '44123032',
      '34124021',
      NULL,
      '301',
      '40',
      NULL,
      NULL,
      NULL,
      3.433217,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34.929238,
      NULL,
      15,
      9.857524,
      12,
      4,
      113.082231,
      0.003619,
      14,
      9,
      24.981119,
      NULL,
      21.745102,
      NULL,
      NULL,
      8,
      27.904574,
      3.846631,
      NULL,
      9.519191,
      NULL,
      17,
      75,
      18,
      0.305109,
      54.589015,
      NULL,
      24.010258,
      95.690962,
      197.700473,
      NULL,
      '11- 9-1975',
      44.506225,
      69.637199,
      23,
      29.120686,
      35.848983,
      NULL,
      ' 9- 0-1980',
      NULL,
      1.445294,
      2.588003,
      NULL,
      2,
      1.980096,
      0.226387,
      1.569416,
      NULL,
      1.617777,
      0,
      1,
      1.549849,
      0.178499,
      1.896520,
      1,
      3.986806,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-14-2001',
      NULL,
      NULL,
      NULL,
      3,
      1.947591,
      4,
      ' 0-26-1986',
      NULL,
      1.328637,
      23.342328,
      0,
      1,
      NULL,
      0.134333,
      1,
      76,
      0,
      NULL,
      201.650447,
      NULL,
      NULL,
      56,
      43,
      111,
      NULL,
      NULL,
      138.676539,
      60,
      22.246256,
      NULL,
      7.275261,
      94,
      ' 2- 1-1997',
      NULL,
      17.445438,
      3.315416,
      61.805396,
      56,
      39,
      3.757687,
      ' 8-13-2000',
      6,
      5.119128,
      ' 0-10-1990',
      6.587845,
      4,
      12,
      20,
      9,
      4.280770,
      0.264858,
      NULL,
      0,
      13.087055,
      1,
      1,
      11.194305,
      6,
      0.708304,
      1,
      NULL,
      0,
      ' 9- 5-1992',
      4.989937,
      3.194513,
      NULL,
      NULL,
      84,
      3,
      ' 9-18-1984',
      22.811524,
      2.609602,
      ' 3-27-1994',
      53,
      ' 9-18-2001',
      40.933458,
      ' 0-26-1995',
      0.549709,
      0.783586,
      ' 1- 4-1982',
      47,
      46.791367,
      '11- 7-1999',
      1.638797,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-28-1987',
      NULL,
      2,
      4,
      NULL,
      57.646849,
      0,
      41,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


