set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7504724';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1421',
      '31313011',
      '22342410',
      '04313312',
      '32342211',
      '33302010',
      '40130302',
      '00021020',
      '40422324',
      '22012410',
      '04013123',
      NULL,
      '01312113',
      '34022020',
      '22014221',
      '42442223',
      '03114010',
      '42223214',
      NULL,
      '30320240',
      '41224443',
      '22324033',
      '40121330',
      NULL,
      '41320043',
      '30303440',
      NULL,
      '23242031',
      '30413104',
      NULL,
      '31130444',
      NULL,
      NULL,
      NULL,
      '02121411',
      '11043233',
      '14014134',
      NULL,
      '02244221',
      '11424001',
      '42140020',
      '44420041',
      '03241123',
      '14304344',
      NULL,
      '221',
      '12',
      36,
      8.331156,
      '3344214',
      NULL,
      1.447243,
      1,
      NULL,
      NULL,
      0.489019,
      ' 4-15-1996',
      '11- 0-1977',
      88,
      96,
      27.861488,
      15.180308,
      7,
      16.586401,
      50,
      6.781220,
      17.736568,
      12,
      30.909479,
      4.356871,
      13,
      NULL,
      16,
      11,
      1.527856,
      4.932799,
      21.532538,
      3.677755,
      23,
      9.961743,
      40,
      18.227286,
      1,
      43.779815,
      72,
      27,
      89.683580,
      130.726027,
      NULL,
      '11- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.219071,
      NULL,
      28.024931,
      1.923526,
      NULL,
      17.218125,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      16.288542,
      10.485217,
      98,
      11.806701,
      90,
      94.913386,
      NULL,
      39.262043,
      NULL,
      19,
      97.272522,
      ' 6-24-1989',
      11,
      17,
      16,
      NULL,
      9,
      46,
      NULL,
      ' 1-18-1984',
      NULL,
      NULL,
      NULL,
      10,
      4.388510,
      10.847430,
      6.877433,
      16.487058,
      2,
      1.878203,
      10,
      0,
      46.410235,
      1.519972,
      0.686531,
      16.948212,
      16.899426,
      1,
      0,
      2,
      0,
      '10- 0-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      37,
      ' 6- 7-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      19,
      ' 9- 2-1975',
      2,
      3,
      41,
      ' 6- 9-1994',
      NULL,
      9,
      ' 5- 4-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


