set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9623778';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32012343',
      '20344210',
      NULL,
      '24301111',
      '10440104',
      '01013142',
      NULL,
      '04010440',
      '34042000',
      '34141012',
      '10402011',
      '23401331',
      '02414423',
      '30123000',
      '22023310',
      '04402213',
      '32042410',
      '33023344',
      '42034234',
      NULL,
      '03222044',
      '03122343',
      NULL,
      '22331144',
      '20300010',
      '41310402',
      '21333402',
      '14040411',
      NULL,
      '13341341',
      NULL,
      '40240130',
      '24123040',
      '42140010',
      '11024304',
      '30224032',
      '14233221',
      '40321213',
      '43000132',
      '00411014',
      '44403322',
      '23102201',
      NULL,
      '44130340',
      '111',
      '13',
      NULL,
      NULL,
      '3231103',
      0.652420,
      1.268826,
      NULL,
      NULL,
      NULL,
      2.865802,
      NULL,
      ' 3- 1-1981',
      NULL,
      NULL,
      NULL,
      5.928171,
      4,
      6,
      12.165975,
      11.698878,
      NULL,
      NULL,
      6,
      NULL,
      42.078089,
      9,
      10,
      NULL,
      28.379679,
      8,
      46,
      12.728391,
      10.351125,
      10,
      39.673226,
      6,
      0,
      84.775030,
      120.915906,
      24,
      76,
      144.434855,
      41,
      ' 3- 8-1981',
      NULL,
      18,
      NULL,
      11,
      123,
      18.081202,
      ' 0-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.696360,
      36.575188,
      NULL,
      NULL,
      14,
      1,
      NULL,
      1,
      NULL,
      94.582529,
      1,
      0,
      90,
      0,
      1,
      34,
      NULL,
      NULL,
      NULL,
      ' 0-29-2001',
      NULL,
      18.582812,
      60.379106,
      77,
      NULL,
      50,
      14.425734,
      NULL,
      NULL,
      68,
      NULL,
      72,
      ' 6-26-1992',
      8.455925,
      7,
      15.352166,
      9.731629,
      36,
      32,
      1.174943,
      ' 8-22-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43.675236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      ' 8-14-1985',
      3,
      8.385585,
      ' 5-29-1978',
      NULL,
      27,
      ' 1-17-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      19.313912,
      ' 2- 0-1982',
      35.081816,
      NULL,
      0,
      ' 1-12-2000',
      3,
      NULL,
      ' 3- 3-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


