set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9877862';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '4',
      '4',
      NULL,
      '1',
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      '1',
      '1',
      '0',
      NULL,
      '4',
      '3',
      NULL,
      '0',
      '3',
      '3',
      NULL,
      '1',
      '3',
      '',
      '1',
      '',
      NULL,
      '0',
      '3',
      NULL,
      '3',
      '',
      '',
      '2',
      '0',
      '1',
      '4',
      '1',
      '0',
      '0',
      '1',
      '0',
      NULL,
      NULL,
      '042',
      NULL,
      77,
      67.255569,
      '1042300',
      1,
      0,
      1,
      0,
      '413004',
      0.108710,
      ' 5-25-1979',
      ' 7-10-2001',
      109.880294,
      121,
      17.924639,
      NULL,
      10,
      NULL,
      32.978615,
      NULL,
      14,
      15,
      22,
      5.764127,
      19.852747,
      15,
      20.465782,
      15.968619,
      11,
      NULL,
      36.413451,
      3,
      15.876164,
      1.302145,
      6,
      11,
      1,
      23.597495,
      NULL,
      21,
      148.352373,
      109,
      91.933357,
      '10-15-1985',
      14.387430,
      30.053484,
      0,
      0,
      NULL,
      18,
      ' 9-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      27,
      6.708149,
      18,
      4,
      ' 1-12-2001',
      0.154961,
      0.550257,
      240,
      0.187507,
      1,
      26,
      0,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      28,
      82,
      4,
      19,
      41,
      52,
      71.604414,
      NULL,
      56.666119,
      9,
      83,
      ' 7-13-1992',
      NULL,
      1.795342,
      2.766781,
      28.880279,
      NULL,
      NULL,
      1,
      ' 0- 8-1989',
      3.792461,
      10,
      ' 9-17-1976',
      5,
      3.206867,
      8.887049,
      13,
      13,
      3.089710,
      1,
      8.301161,
      0.783339,
      6,
      8,
      NULL,
      NULL,
      14,
      11,
      1,
      0,
      0,
      ' 0-15-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      NULL,
      '10-10-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 3-1989',
      32.461526,
      ' 3-18-1979',
      16,
      3,
      NULL,
      99,
      71.113339,
      ' 4-25-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      ' 0- 6-1996',
      1,
      9.435595,
      NULL,
      ' 6-26-1997',
      0,
      0.650216,
      NULL,
      NULL,
      28,
      15.877219,
      58,
      '10-11-1987',
      66.142008,
      0.247292,
      22.936093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


