set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9004202';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0022',
      '34344043',
      '33221242',
      '12034114',
      '40021020',
      NULL,
      '00424132',
      '23020411',
      '12041204',
      NULL,
      '32221003',
      '23231124',
      '31124323',
      '20310240',
      '30412240',
      '11120311',
      '00204010',
      NULL,
      '00104331',
      NULL,
      '20341021',
      '03223041',
      NULL,
      NULL,
      '34134433',
      NULL,
      '30124313',
      '42234303',
      '20343034',
      '22241110',
      '14202113',
      NULL,
      '23234202',
      '41021040',
      '03422023',
      NULL,
      '00031102',
      '30440232',
      '20303142',
      '03223234',
      '40432311',
      '43444102',
      '23043403',
      '21430221',
      '30024204',
      '404',
      '23',
      NULL,
      7,
      '4434120',
      2.614197,
      0.759030,
      NULL,
      NULL,
      '313032',
      2,
      ' 0- 7-2001',
      ' 4-10-2002',
      12,
      21,
      4.411029,
      12.607576,
      0.852074,
      19.298909,
      63.307832,
      7.572298,
      29.239558,
      22.261591,
      50,
      NULL,
      15,
      6,
      10.168395,
      NULL,
      29.638022,
      NULL,
      89.030559,
      26,
      6,
      16.209066,
      129,
      11.712325,
      0.997255,
      91,
      1,
      115,
      214,
      246,
      153,
      ' 8-19-2003',
      40,
      29.401625,
      23,
      10,
      NULL,
      167,
      '11-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      4,
      8.721790,
      1.990202,
      1.534667,
      NULL,
      ' 1- 5-1999',
      1.489998,
      0.762554,
      170,
      0.521181,
      0.928560,
      76,
      0,
      3,
      28.004933,
      NULL,
      NULL,
      NULL,
      ' 9-22-1974',
      99.115779,
      13.472151,
      39.322328,
      20,
      42.624105,
      106,
      NULL,
      NULL,
      91.459401,
      84,
      NULL,
      7.070349,
      '10-15-1998',
      NULL,
      14,
      4,
      NULL,
      61.130176,
      153,
      3.354421,
      ' 0- 7-1978',
      NULL,
      20.166092,
      ' 5-10-1981',
      0.251797,
      0.743016,
      14,
      21,
      9.922696,
      NULL,
      0,
      5.431420,
      1,
      50.563141,
      14,
      NULL,
      7,
      8,
      3.949753,
      NULL,
      NULL,
      1,
      ' 3-19-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      91.615304,
      NULL,
      ' 7-21-1995',
      NULL,
      NULL,
      NULL,
      41,
      ' 1- 0-2003',
      NULL,
      ' 0-14-1996',
      13.856142,
      6.060026,
      ' 9-26-1981',
      122.188499,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      26,
      NULL,
      37,
      NULL,
      0,
      79,
      ' 6-15-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


